/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import java.util.Collection;
import java.util.Map;

public abstract class BaseMapWrapper<K, V> {
    protected void doPut(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        try {
            K key = keyUnsafeSupplier.get();
            if (key == null) {
                return;
            }
            if (valueUnsafeSupplier == null) {
                this._put(key, null);
                return;
            }
            V value = valueUnsafeSupplier.get();
            if (value != null) {
                this._put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPut(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        try {
            K key = keyUnsafeSupplier.get();
            if (key != null) {
                this._put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPut(Collection<? extends K> keyCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        try {
            for (K key : keyCollection) {
                V value = unsafeFunction.apply(key);
                if (value == null) continue;
                this._put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPut(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        if (valueUnsafeSupplier == null) {
            this._put(key, null);
            return;
        }
        try {
            V value = valueUnsafeSupplier.get();
            if (value != null) {
                this._put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Map<K, V> getMap();

    private void _put(K key, V value) {
        Map<K, V> map = this.getMap();
        map.put(key, value);
    }
}

