/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.LinkedHashMap;

public class LinkedHashMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> LinkedHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        LinkedHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>> linkedHashMapWrapper = new LinkedHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>();
        return linkedHashMapWrapper.put(inputCollection, unsafeFunction);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> linkedHashMapWrapper = new LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return linkedHashMapWrapper.put(key, valueUnsafeSupplier);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(K key, V value) {
        LinkedHashMapWrapper<K, V> linkedHashMapWrapper = new LinkedHashMapWrapper<K, V>();
        return linkedHashMapWrapper.put(key, value);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> linkedHashMapWrapper = new LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return linkedHashMapWrapper.put(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        LinkedHashMapWrapper<K, V> linkedHashMapWrapper = new LinkedHashMapWrapper<K, V>();
        return linkedHashMapWrapper.put(keyUnsafeSupplier, value);
    }

    public static final class LinkedHashMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final LinkedHashMap<K, V> _linkedHashMap = new LinkedHashMap();

        public LinkedHashMap<K, V> build() {
            return this._linkedHashMap;
        }

        public LinkedHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(K key, V value) {
            this._linkedHashMap.put(key, value);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        @Override
        protected LinkedHashMap<K, V> getMap() {
            return this._linkedHashMap;
        }
    }
}

