/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.TreeMap;

public class TreeMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> TreeMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        TreeMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>> treeMapWrapper = new TreeMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>();
        return treeMapWrapper.put(inputCollection, unsafeFunction);
    }

    public static <K, V> TreeMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        TreeMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> treeMapWrapper = new TreeMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return treeMapWrapper.put(key, valueUnsafeSupplier);
    }

    public static <K, V> TreeMapWrapper<K, V> put(K key, V value) {
        TreeMapWrapper<K, V> treeMapWrapper = new TreeMapWrapper<K, V>();
        return treeMapWrapper.put(key, value);
    }

    public static <K, V> TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        TreeMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> treeMapWrapper = new TreeMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return treeMapWrapper.put(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        TreeMapWrapper<K, V> treeMapWrapper = new TreeMapWrapper<K, V>();
        return treeMapWrapper.put(keyUnsafeSupplier, value);
    }

    public static final class TreeMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final TreeMap<K, V> _treeMap = new TreeMap();

        public TreeMap<K, V> build() {
            return this._treeMap;
        }

        public TreeMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public TreeMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public TreeMapWrapper<K, V> put(K key, V value) {
            this._treeMap.put(key, value);
            return this;
        }

        public TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        @Override
        protected TreeMap<K, V> getMap() {
            return this._treeMap;
        }
    }
}

