/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.IOException;
import org.json.JSONObject;

public class JSONPackageJSONCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/package.json") || !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/") && !absolutePath.contains("/modules/private/apps/")) {
            return content;
        }
        String dirName = absolutePath.substring(0, absolutePath.length() - 12);
        if (!FileUtil.exists(dirName + "build.gradle") && !FileUtil.exists(dirName + "bnd.bnd")) {
            return content;
        }
        JSONObject jsonObject = new JSONObject(content);
        this._checkIncorrectEntry(fileName, jsonObject, "devDependencies");
        if (jsonObject.isNull("scripts")) {
            return content;
        }
        JSONObject scriptsJSONObject = jsonObject.getJSONObject("scripts");
        if (absolutePath.contains("/modules/apps/frontend-theme")) {
            this._checkScript(fileName, scriptsJSONObject, "build", "liferay-npm-scripts theme build", false);
        } else {
            this._checkScript(fileName, scriptsJSONObject, "build", "liferay-npm-scripts build", false);
        }
        this._checkScript(fileName, scriptsJSONObject, "checkFormat", "liferay-npm-scripts check", true);
        this._checkScript(fileName, scriptsJSONObject, "format", "liferay-npm-scripts fix", true);
        return content;
    }

    private void _checkIncorrectEntry(String fileName, JSONObject jsonObject, String entryName) {
        if (!jsonObject.isNull(entryName)) {
            this.addMessage(fileName, "Entry '" + entryName + "' is not allowed");
        }
    }

    private void _checkScript(String fileName, JSONObject scriptsJSONObject, String key, String expectedValue, boolean requiredScript) {
        if (scriptsJSONObject.isNull(key)) {
            if (requiredScript) {
                this.addMessage(fileName, "Missing entry '" + key + "' in 'scripts'");
            }
            return;
        }
        String value = scriptsJSONObject.getString(key);
        if (!value.contains(expectedValue)) {
            this.addMessage(fileName, StringBundler.concat("Value '", value, "' for entry '", key, "' does not contain '", expectedValue, "'"));
        }
    }
}

