/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterCheckUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseCheck
extends AbstractCheck {
    protected static final int[] ARITHMETIC_OPERATOR_TOKEN_TYPES = new int[]{127, 126, 128, 125, 60};
    protected static final int[] RELATIONAL_OPERATOR_TOKEN_TYPES = new int[]{116, 120, 118, 119, 117, 115};
    private JSONObject _attributesJSONObject = new JSONObjectImpl();
    private final Map<String, String> _attributeValueMap = new ConcurrentHashMap<String, String>();
    private final Map<String, List<String>> _attributeValuesMap = new ConcurrentHashMap<String, List<String>>();
    private JSONObject _excludesJSONObject = new JSONObjectImpl();
    private final Map<String, List<String>> _excludesValuesMap = new ConcurrentHashMap<String, List<String>>();

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setAttributes(String attributes) throws JSONException {
        this._attributesJSONObject = new JSONObjectImpl(attributes);
    }

    public void setExcludes(String excludes) throws JSONException {
        this._excludesJSONObject = new JSONObjectImpl(excludes);
    }

    public void visitToken(DetailAST detailAST) {
        if (!this.isAttributeValue("enabled", true)) {
            return;
        }
        if (!this.isAttributeValue("showDebugInformation")) {
            this.doVisitToken(detailAST);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.doVisitToken(detailAST);
        long endTime = System.currentTimeMillis();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DebugUtil.increaseProcessingTime(clazz.getSimpleName(), endTime - startTime);
    }

    protected abstract void doVisitToken(DetailAST var1);

    protected String getAbsolutePath() {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        return SourceUtil.getAbsolutePath(fileName);
    }

    protected String getAttributeValue(String attributeKey) {
        return this.getAttributeValue(attributeKey, "");
    }

    protected String getAttributeValue(String attributeKey, String defaultValue) {
        return SourceFormatterCheckUtil.getJSONObjectValue(this._attributesJSONObject, this._attributeValueMap, attributeKey, defaultValue, this.getAbsolutePath(), this.getBaseDirName());
    }

    protected List<String> getAttributeValues(String attributeKey) {
        return SourceFormatterCheckUtil.getJSONObjectValues(this._attributesJSONObject, attributeKey, this._attributeValuesMap, this.getAbsolutePath(), this.getBaseDirName());
    }

    protected String getBaseDirName() {
        return SourceFormatterCheckUtil.getJSONObjectValue(this._attributesJSONObject, this._attributeValueMap, "baseDirName", "", null, null, true);
    }

    protected boolean isAttributeValue(String attributeKey) {
        return GetterUtil.getBoolean(this.getAttributeValue(attributeKey));
    }

    protected boolean isAttributeValue(String attributeKey, boolean defaultValue) {
        String attributeValue = this.getAttributeValue(attributeKey);
        if (Validator.isNull(attributeValue)) {
            return defaultValue;
        }
        return GetterUtil.getBoolean(attributeValue);
    }

    protected boolean isExcludedPath(String key) {
        return SourceFormatterCheckUtil.isExcludedPath(this._excludesJSONObject, this._excludesValuesMap, key, this.getAbsolutePath(), -1, null, this.getBaseDirName());
    }
}

