/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DetailASTUtil {
    public static final int ALL_TYPES = -1;

    public static List<DetailAST> getAllChildTokens(DetailAST detailAST, boolean recursive, int ... tokenTypes) {
        return DetailASTUtil._getAllChildTokens(detailAST, recursive, null, tokenTypes);
    }

    public static int getEndLineNumber(DetailAST detailAST) {
        int endLineNumber = detailAST.getLineNo();
        for (DetailAST childDetailAST : DetailASTUtil.getAllChildTokens(detailAST, true, -1)) {
            if (childDetailAST.getLineNo() <= endLineNumber) continue;
            endLineNumber = childDetailAST.getLineNo();
        }
        return endLineNumber;
    }

    public static CommonHiddenStreamToken getHiddenBefore(DetailAST detailAST) {
        CommonASTWithHiddenTokens commonASTWithHiddenTokens = (CommonASTWithHiddenTokens)detailAST;
        return commonASTWithHiddenTokens.getHiddenBefore();
    }

    public static List<String> getImportNames(DetailAST detailAST) {
        DetailAST rootDetailAST = detailAST;
        while (true) {
            if (rootDetailAST.getParent() != null) {
                rootDetailAST = rootDetailAST.getParent();
                continue;
            }
            if (rootDetailAST.getPreviousSibling() == null) break;
            rootDetailAST = rootDetailAST.getPreviousSibling();
        }
        ArrayList<String> importNamesList = new ArrayList<String>();
        DetailAST siblingDetailAST = rootDetailAST.getNextSibling();
        while (siblingDetailAST != null && siblingDetailAST.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)siblingDetailAST);
            importNamesList.add(importIdent.getText());
            siblingDetailAST = siblingDetailAST.getNextSibling();
        }
        return importNamesList;
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String methodName) {
        return DetailASTUtil.getMethodCalls(detailAST, null, methodName);
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String className, String methodName) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<DetailAST> nameDetailASTList;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST == null || (nameDetailASTList = DetailASTUtil.getAllChildTokens(dotDetailAST, false, 58)).size() != 2) continue;
            DetailAST classNameDetailAST = nameDetailASTList.get(0);
            DetailAST methodNameDetailAST = nameDetailASTList.get(1);
            String methodCallClassName = classNameDetailAST.getText();
            String methodCallMethodName = methodNameDetailAST.getText();
            if (className != null && !methodCallClassName.equals(className) || !methodCallMethodName.equals(methodName)) continue;
            list.add(methodCallDetailAST);
        }
        return list;
    }

    public static String getMethodName(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return null;
        }
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            DetailAST nameDetailAST = detailAST.findFirstToken(58);
            return nameDetailAST.getText();
        }
        List<DetailAST> nameDetailASTList = DetailASTUtil.getAllChildTokens(dotDetailAST, false, 58);
        DetailAST methodNameDetailAST = nameDetailASTList.get(nameDetailASTList.size() - 1);
        return methodNameDetailAST.getText();
    }

    public static List<DetailAST> getParameterDefs(DetailAST detailAST) {
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return new ArrayList<DetailAST>();
        }
        DetailAST parametersDetailAST = detailAST.findFirstToken(20);
        return DetailASTUtil.getAllChildTokens(parametersDetailAST, false, 21);
    }

    public static List<String> getParameterNames(DetailAST detailAST) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (DetailAST parameterDefinitionDetailAST : DetailASTUtil.getParameterDefs(detailAST)) {
            DetailAST identDetailAST = parameterDefinitionDetailAST.findFirstToken(58);
            parameterNames.add(identDetailAST.getText());
        }
        return parameterNames;
    }

    public static DetailAST getParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (!ArrayUtil.contains(tokenTypes, parentDetailAST.getType())) continue;
            return parentDetailAST;
        }
        return null;
    }

    public static String getSignature(DetailAST detailAST) {
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return "";
        }
        StringBundler sb = new StringBundler();
        sb.append('(');
        DetailAST parametersDetailAST = detailAST.findFirstToken(20);
        List<DetailAST> parameterDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(parametersDetailAST, false, 21);
        if (parameterDefinitionDetailASTList.isEmpty()) {
            sb.append(')');
            return sb.toString();
        }
        for (DetailAST parameterDefinitionDetailAST : parameterDefinitionDetailASTList) {
            sb.append(DetailASTUtil.getTypeName(parameterDefinitionDetailAST, true));
            sb.append(',');
        }
        sb.setIndex(sb.index() - 1);
        sb.append(')');
        return sb.toString();
    }

    public static int getStartLineNumber(DetailAST detailAST) {
        int startLineNumber = detailAST.getLineNo();
        for (DetailAST childDetailAST : DetailASTUtil.getAllChildTokens(detailAST, true, -1)) {
            if (childDetailAST.getLineNo() >= startLineNumber) continue;
            startLineNumber = childDetailAST.getLineNo();
        }
        return startLineNumber;
    }

    public static String getTypeName(DetailAST detailAST, boolean includeTypeArguments) {
        DetailAST childDetailAST;
        if (detailAST == null) {
            return "";
        }
        DetailAST typeDetailAST = detailAST;
        if (detailAST.getType() != 13 && detailAST.getType() != 164) {
            typeDetailAST = detailAST.findFirstToken(13);
        }
        if ((childDetailAST = typeDetailAST.getFirstChild()) == null) {
            return "";
        }
        int arrayDimension = 0;
        while (childDetailAST.getType() == 17) {
            ++arrayDimension;
            childDetailAST = childDetailAST.getFirstChild();
        }
        StringBundler sb = new StringBundler(1 + arrayDimension);
        FullIdent typeIdent = FullIdent.createFullIdent((DetailAST)childDetailAST);
        sb.append(typeIdent.getText());
        for (int i = 0; i < arrayDimension; ++i) {
            sb.append("[]");
        }
        if (!includeTypeArguments) {
            return sb.toString();
        }
        DetailAST typeArgumentsDetailAST = typeDetailAST.findFirstToken(163);
        if (typeArgumentsDetailAST == null) {
            return sb.toString();
        }
        sb.append('<');
        List<DetailAST> typeArgumentDetailASTList = DetailASTUtil.getAllChildTokens(typeArgumentsDetailAST, false, 164);
        for (DetailAST typeArgumentDetailAST : typeArgumentDetailASTList) {
            sb.append(DetailASTUtil.getTypeName(typeArgumentDetailAST, true));
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append('>');
        return sb.toString();
    }

    public static String getVariableName(DetailAST methodCallDetailAST) {
        DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return null;
        }
        DetailAST nameDetailAST = dotDetailAST.findFirstToken(58);
        if (nameDetailAST == null) {
            return null;
        }
        return nameDetailAST.getText();
    }

    public static DetailAST getVariableTypeDetailAST(DetailAST detailAST, String variableName) {
        DetailAST previousDetailAST = detailAST;
        while (true) {
            DetailAST previousSiblingDetailAST;
            if (previousDetailAST.getType() == 14 || previousDetailAST.getType() == 154 || previousDetailAST.getType() == 15) {
                DetailAST objBlockDetailAST = previousDetailAST.findFirstToken(6);
                Iterator<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(objBlockDetailAST, false, 10);
                Iterator<DetailAST> iterator = variableDefinitionDetailASTList.iterator();
                while (iterator.hasNext()) {
                    DetailAST variableDefinitionDetailAST = iterator.next();
                    if (!variableName.equals(DetailASTUtil._getVariableName(variableDefinitionDetailAST))) continue;
                    return variableDefinitionDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 156 || previousDetailAST.getType() == 35) {
                List<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(previousDetailAST, false, 10);
                for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
                    if (!variableName.equals(DetailASTUtil._getVariableName(variableDefinitionDetailAST))) continue;
                    return variableDefinitionDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 96 || previousDetailAST.getType() == 20) {
                List<DetailAST> parameterDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(previousDetailAST, false, 21);
                for (DetailAST parameterDefinitionDetailAST : parameterDefinitionDetailASTList) {
                    if (!variableName.equals(DetailASTUtil._getVariableName(parameterDefinitionDetailAST))) continue;
                    return parameterDefinitionDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 176) {
                DetailAST recourcesDetailAST = previousDetailAST.findFirstToken(177);
                List<DetailAST> resourceDetailASTList = DetailASTUtil.getAllChildTokens(recourcesDetailAST, false, 178);
                for (DetailAST resourceDetailAST : resourceDetailASTList) {
                    if (!variableName.equals(DetailASTUtil._getVariableName(resourceDetailAST))) continue;
                    return resourceDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 10 && variableName.equals(DetailASTUtil._getVariableName(previousDetailAST))) {
                return previousDetailAST.findFirstToken(13);
            }
            if ((previousSiblingDetailAST = previousDetailAST.getPreviousSibling()) != null) {
                previousDetailAST = previousSiblingDetailAST;
                continue;
            }
            DetailAST parentDetailAST = previousDetailAST.getParent();
            if (parentDetailAST == null) break;
            previousDetailAST = parentDetailAST;
        }
        return null;
    }

    public static String getVariableTypeName(DetailAST detailAST, String variableName, boolean includeTypeArguments) {
        return DetailASTUtil.getTypeName(DetailASTUtil.getVariableTypeDetailAST(detailAST, variableName), includeTypeArguments);
    }

    public static boolean hasParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        DetailAST parentDetailAST = DetailASTUtil.getParentWithTokenType(detailAST, tokenTypes);
        return parentDetailAST != null;
    }

    public static boolean isArray(DetailAST detailAST) {
        if (detailAST.getType() != 13) {
            return false;
        }
        DetailAST arrayDeclaratorDetailAST = detailAST.findFirstToken(17);
        return arrayDeclaratorDetailAST != null;
    }

    public static boolean isAtLineEnd(DetailAST detailAST, String line) {
        String text = detailAST.getText();
        return line.endsWith(text) && detailAST.getColumnNo() + text.length() == line.length();
    }

    public static boolean isAtLineStart(DetailAST detailAST, String line) {
        for (int i = 0; i < detailAST.getColumnNo(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    public static boolean isCollection(DetailAST detailAST) {
        if (detailAST.getType() != 13) {
            return false;
        }
        DetailAST typeArgumentsDetailAST = detailAST.findFirstToken(163);
        if (typeArgumentsDetailAST == null) {
            return false;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        return name.matches(".*(Collection|List|Map|Set)");
    }

    private static List<DetailAST> _getAllChildTokens(DetailAST detailAST, boolean recursive, List<DetailAST> list, int ... tokenTypes) {
        if (list == null) {
            list = new ArrayList<DetailAST>();
        }
        for (DetailAST childDetailAST = detailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
            if (ArrayUtil.contains(tokenTypes, childDetailAST.getType()) || ArrayUtil.contains(tokenTypes, -1)) {
                list.add(childDetailAST);
            }
            if (!recursive) continue;
            list = DetailASTUtil._getAllChildTokens(childDetailAST, recursive, list, tokenTypes);
        }
        return list;
    }

    private static String _getVariableName(DetailAST variableDefinitionDetailAST) {
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        return nameDetailAST.getText();
    }
}

