/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProxyFactory {
    private static final Log _log = LogFactoryUtil.getLog(ProxyFactory.class);

    public static <T> T newDummyInstance(Class<T> interfaceClass) {
        return (T)ProxyUtil.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new DummyInvocationHandler());
    }

    public static Object newInstance(ClassLoader classLoader, Class<?> interfaceClass, String implClassName) throws Exception {
        return ProxyFactory.newInstance(classLoader, new Class[]{interfaceClass}, implClassName);
    }

    public static Object newInstance(ClassLoader classLoader, Class<?>[] interfaceClasses, String implClassName) throws Exception {
        Object instance = InstanceFactory.newInstance(classLoader, implClassName);
        return ProxyUtil.newProxyInstance(classLoader, interfaceClasses, (InvocationHandler)new ClassLoaderBeanHandler(instance, classLoader));
    }

    private static class ServiceTrackedInvocationHandler<T>
    implements InvocationHandler {
        private final String _interfaceClassName;
        private final ServiceTracker<T, T> _serviceTracker;

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Class<?> returnType;
            Object service = this._serviceTracker.getService();
            if (service != null) {
                try {
                    return method.invoke(service, arguments);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat("Skipping ", method.getName(), " because ", this._interfaceClassName, " is not registered"));
            }
            if ((returnType = method.getReturnType()).equals(Boolean.TYPE)) {
                return false;
            }
            if (returnType.equals(Byte.TYPE)) {
                return (byte)0;
            }
            if (returnType.equals(Double.TYPE)) {
                return 0.0;
            }
            if (returnType.equals(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (returnType.equals(Integer.TYPE)) {
                return 0;
            }
            if (returnType.equals(Long.TYPE)) {
                return 0L;
            }
            if (returnType.equals(Short.TYPE)) {
                return (short)0;
            }
            return method.getDefaultValue();
        }

        private ServiceTrackedInvocationHandler(Class<T> interfaceClass) {
            this(interfaceClass, null);
        }

        private ServiceTrackedInvocationHandler(Class<T> interfaceClass, String filterString) {
            this._interfaceClassName = interfaceClass.getName();
            Registry registry = RegistryUtil.getRegistry();
            if (Validator.isNull(filterString)) {
                this._serviceTracker = registry.trackServices(interfaceClass);
            } else {
                StringBundler sb = new StringBundler(7);
                sb.append("(&(objectClass=");
                sb.append(this._interfaceClassName);
                sb.append(")");
                if (!filterString.startsWith("(")) {
                    sb.append("(");
                }
                sb.append(filterString);
                if (!filterString.endsWith(")")) {
                    sb.append(")");
                }
                sb.append(")");
                Filter filter = registry.getFilter(sb.toString());
                this._serviceTracker = registry.trackServices(filter);
            }
            this._serviceTracker.open();
        }
    }

    private static class DummyInvocationHandler<T>
    implements InvocationHandler {
        private DummyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(Boolean.TYPE)) {
                return false;
            }
            if (returnType.equals(Byte.TYPE)) {
                return (byte)0;
            }
            if (returnType.equals(Double.TYPE)) {
                return 0.0;
            }
            if (returnType.equals(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (returnType.equals(Integer.TYPE)) {
                return 0;
            }
            if (returnType.equals(Long.TYPE)) {
                return 0L;
            }
            if (returnType.equals(Short.TYPE)) {
                return (short)0;
            }
            return method.getDefaultValue();
        }
    }
}

