/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.DefinitionKeysCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDDefinitionKeysCheck
extends DefinitionKeysCheck {
    private static final Pattern _definitionKeyPattern = Pattern.compile("([A-Za-z-.]+?)[:=]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> definitions = this.getDefinitions(content);
        if (definitions.isEmpty()) {
            return content;
        }
        content = this.sortDefinitionKeys(content, definitions, new DefinitionComparator());
        Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = BNDSourceUtil.getFileSpecificDefinitionKeysMap();
        Map<String, String> generalDefinitionKeysMap = BNDSourceUtil.getDefinitionKeysMap();
        for (String definition : definitions) {
            content = this._formatDefinitionKey(fileName, content, definition, fileSpecificDefinitionKeysMap, generalDefinitionKeysMap);
        }
        return content;
    }

    private String _formatDefinitionKey(String fileName, String content, String definition, Map<String, Map<String, String>> fileSpecificDefinitionKeysMap, Map<String, String> generalDefinitionKeysMap) {
        int pos;
        String shortFileName;
        Map<String, String> definitionKeysMap;
        if (definition.endsWith(",\\")) {
            return StringUtil.replace(content, definition, definition.substring(0, definition.length() - 2));
        }
        Matcher matcher = _definitionKeyPattern.matcher(definition);
        if (!matcher.find()) {
            return content;
        }
        String definitionKey = matcher.group(1);
        if (definitionKey.contains(".")) {
            definitionKey = StringUtil.extractFirst(definitionKey, ".");
        }
        String lowerCaseDefinitionKey = StringUtil.toLowerCase(definitionKey);
        String correctKey = null;
        correctKey = definitionKey.equals("Conditional-Package") ? "-conditionalpackage" : generalDefinitionKeysMap.get(lowerCaseDefinitionKey);
        if (correctKey == null && (definitionKeysMap = fileSpecificDefinitionKeysMap.get(shortFileName = fileName.substring((pos = fileName.lastIndexOf("/")) + 1))) != null) {
            correctKey = definitionKeysMap.get(lowerCaseDefinitionKey);
        }
        if (correctKey == null) {
            this.addMessage(fileName, "Unknown key \"" + definitionKey + "\"", "bnd_definition_keys.markdown");
            return content;
        }
        if (correctKey.equals(definitionKey)) {
            return StringUtil.replace(content, definitionKey + "=", definitionKey + ":");
        }
        if (content.startsWith(definitionKey)) {
            return StringUtil.replaceFirst(content, definitionKey, correctKey);
        }
        return StringUtil.replace(content, "\n" + definitionKey + ":", "\n" + correctKey + ":");
    }

    private static class DefinitionComparator
    implements Comparator<String> {
        private DefinitionComparator() {
        }

        @Override
        public int compare(String definition1, String definition2) {
            if (definition1.startsWith("-") ^ definition2.startsWith("-")) {
                return -definition1.compareTo(definition2);
            }
            return definition1.compareTo(definition2);
        }
    }
}

