/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDExportsCheck
extends BaseFileCheck {
    private static final String _ALLOWED_EXPORT_PACKAGE_DIR_NAMES_KEY = "allowedExportPackageDirNames";
    private static final Pattern _apiOrServiceBundleSymbolicNamePattern = Pattern.compile("\\.(api|service)$");
    private static final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/bnd.bnd") || absolutePath.contains("/third-party/")) {
            return content;
        }
        if (!absolutePath.contains("/testIntegration/")) {
            this._checkExports(fileName, content, _exportContentsPattern, "-exportcontents");
            this._checkExports(fileName, content, _exportsPattern, "Export-Package");
        }
        if (absolutePath.contains("/modules/apps/")) {
            this._checkAllowedExportPackages(fileName, absolutePath, content);
        }
        this._checkExportPackages(fileName, content, this.isModulesFile(absolutePath));
        return content;
    }

    private void _checkAllowedExportPackages(String fileName, String absolutePath, String content) {
        List<String> allowedExportPackageDirNames = this.getAttributeValues(_ALLOWED_EXPORT_PACKAGE_DIR_NAMES_KEY, absolutePath);
        for (String allowedExportPackageDirName : allowedExportPackageDirNames) {
            if (!absolutePath.contains(allowedExportPackageDirName)) continue;
            return;
        }
        if (fileName.endsWith("/test-bnd.bnd") || absolutePath.contains("-api/") || absolutePath.contains("-client/") || absolutePath.contains("-spi/") || absolutePath.contains("-taglib/") || absolutePath.contains("-test-util/") || !content.contains("Export-Package")) {
            return;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        this.addMessage(fileName, "Exporting packages not allowed in module '" + absolutePath.substring(y + 1, x) + "'", "bnd_exports.markdown");
    }

    private void _checkExportPackage(String fileName, String srcDirLocation, String exportPackage, boolean modulesFile) throws IOException {
        int i;
        File importedFilesPropertiesFile;
        String exportPackagePath = StringUtil.replace(exportPackage, '.', '/');
        Object[] exportPackageResourcesFiles = this._getExportPackageResourcesFiles(srcDirLocation, exportPackagePath, modulesFile);
        Object[] exportPackageSrcFiles = this._getExportPackageSrcFiles(srcDirLocation, exportPackagePath, modulesFile);
        if (ArrayUtil.isNotEmpty(exportPackageResourcesFiles) || ArrayUtil.isNotEmpty(exportPackageSrcFiles)) {
            File packageinfoFile = null;
            packageinfoFile = modulesFile ? new File(StringBundler.concat(srcDirLocation, "main/resources/", exportPackagePath, "/packageinfo")) : new File(StringBundler.concat(srcDirLocation, exportPackagePath, "/packageinfo"));
            if (!packageinfoFile.exists()) {
                this.addMessage(fileName, "Added packageinfo for " + exportPackage);
                FileUtil.write(packageinfoFile, "version 1.0.0");
            }
        } else if (exportPackage.startsWith("com.liferay.") && !(importedFilesPropertiesFile = new File(fileName.substring(0, i = fileName.lastIndexOf("/")) + "/imported-files.properties")).exists()) {
            this.addMessage(fileName, "Unneeded/incorrect Export-Package: " + exportPackage);
        }
    }

    private void _checkExportPackages(String fileName, String content, boolean modulesFile) throws IOException {
        List<String> exportPackages = this._getExportPackages(content);
        if (exportPackages.isEmpty()) {
            return;
        }
        String srcDirLocation = this._getSrcDirLocation(fileName, modulesFile);
        if (srcDirLocation == null) {
            return;
        }
        ArrayList<String> removedExportPackages = new ArrayList<String>();
        for (String exportPackage : exportPackages) {
            if (exportPackage.startsWith("!")) {
                removedExportPackages.add(StringUtil.replace(exportPackage.substring(1), '.', '/'));
                continue;
            }
            if (exportPackage.endsWith(".*")) {
                this._checkWildCardExportPackage(fileName, srcDirLocation, exportPackage, removedExportPackages);
                continue;
            }
            this._checkExportPackage(fileName, srcDirLocation, exportPackage, modulesFile);
        }
    }

    private void _checkExports(String fileName, String content, Pattern pattern, String definitionKey) {
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName == null || bundleSymbolicName.startsWith("$") || bundleSymbolicName.endsWith(".compat")) {
            return;
        }
        Matcher matcher = _apiOrServiceBundleSymbolicNamePattern.matcher(bundleSymbolicName);
        bundleSymbolicName = matcher.replaceAll("");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String[] lines = StringUtil.splitLines(matcher.group(2));
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtil.removeChar(StringUtil.trim(lines[i]), '\\');
            if (Validator.isNull(line) || !line.startsWith("com.liferay.") || line.startsWith(bundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(6);
            sb.append(definitionKey);
            sb.append(" '");
            sb.append(line);
            sb.append("' should match Bundle-SymbolicName '");
            sb.append(bundleSymbolicName);
            sb.append("'");
            this.addMessage(fileName, sb.toString(), this.getLineNumber(content, matcher.start(2)) + i);
        }
    }

    private void _checkWildCardExportPackage(final String fileName, String srcDirLocation, String wildCardExportPackage, final List<String> removedExportPackages) throws IOException {
        String wildCardExportPackagePath = StringUtil.replace(wildCardExportPackage, '.', '/');
        File exportPackageSrcDir = new File(StringBundler.concat(srcDirLocation, "/", StringUtil.removeSubstring(wildCardExportPackagePath, "/*")));
        if (!exportPackageSrcDir.exists()) {
            this.addMessage(fileName, "Unneeded/incorrect Export-Package: " + wildCardExportPackage);
            return;
        }
        Files.walkFileTree(exportPackageSrcDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                File dirFile = dirPath.toFile();
                File packageinfoFile = new File(dirFile, "packageinfo");
                if (packageinfoFile.exists()) {
                    return FileVisitResult.CONTINUE;
                }
                Object[] javaFiles = dirFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (!pathname.isFile()) {
                            return false;
                        }
                        String fileName = pathname.getName();
                        return fileName.endsWith(".java");
                    }
                });
                if (ArrayUtil.isEmpty(javaFiles)) {
                    return FileVisitResult.CONTINUE;
                }
                String absolutePath = SourceUtil.getAbsolutePath(dirFile);
                for (String removedExportPackage : removedExportPackages) {
                    if (!(!removedExportPackage.endsWith("/*") ? absolutePath.endsWith(removedExportPackage) : absolutePath.contains(StringUtil.removeSubstring(removedExportPackage, "/*")))) continue;
                    return FileVisitResult.CONTINUE;
                }
                BNDExportsCheck.this.addMessage(fileName, "Added packageinfo in " + absolutePath);
                FileUtil.write(packageinfoFile, "version 1.0.0");
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private File[] _getExportPackageResourcesFiles(String srcDirLocation, String exportPackagePath, boolean modulesFile) {
        if (!modulesFile) {
            return new File[0];
        }
        File exportPackageResourcesDir = new File(StringBundler.concat(srcDirLocation, "/main/resources/", exportPackagePath));
        return exportPackageResourcesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                if (fileName.startsWith(".lfrbuild-") || fileName.equals("packageinfo")) {
                    return false;
                }
                return pathname.isFile();
            }
        });
    }

    private List<String> _getExportPackages(String content) {
        Matcher matcher = _exportsPattern.matcher(content);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> exportPackages = new ArrayList<String>();
        for (String line : StringUtil.splitLines(matcher.group(3))) {
            if (!Validator.isNotNull(line = StringUtil.trim(line)) || line.equals("\\") || line.contains(";")) continue;
            exportPackages.add(StringUtil.removeSubstring(line, ",\\"));
        }
        return exportPackages;
    }

    private File[] _getExportPackageSrcFiles(String srcDirLocation, String exportPackagePath, boolean modulesFile) {
        File exportPackageSrcDir = null;
        exportPackageSrcDir = modulesFile ? new File(StringBundler.concat(srcDirLocation, "/main/java/", exportPackagePath)) : new File(StringBundler.concat(srcDirLocation, "/", exportPackagePath));
        return exportPackageSrcDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
    }

    private String _getSrcDirLocation(String fileName, boolean modulesFile) {
        int i = fileName.lastIndexOf("/");
        String srcDirLocation = fileName.substring(0, i) + "/src/";
        if (modulesFile) {
            File srcMainDir = new File(srcDirLocation + "main/");
            if (srcMainDir.exists()) {
                return srcDirLocation;
            }
            return null;
        }
        File comLiferayDir = new File(srcDirLocation + "com/liferay/");
        if (comLiferayDir.exists()) {
            return srcDirLocation;
        }
        return null;
    }
}

