/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.TagAttributesCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checks.util.TaglibUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JSPTagAttributesCheck
extends TagAttributesCheck {
    private static final String[] _SINGLE_LINE_TAG_WHITELIST = new String[]{"liferay-frontend:defineObjects", "liferay-portlet:actionURL", "liferay-portlet:param", "liferay-portlet:renderURL", "liferay-portlet:renderURLParams", "liferay-portlet:resourceURL", "liferay-staging:defineObjects", "liferay-theme:defineObjects", "liferay-ui:error", "liferay-ui:icon-help", "liferay-ui:message", "liferay-ui:success", "liferay-util:dynamic-include", "liferay-util:include", "liferay-util:param"};
    private static final Pattern _jspTaglibPattern = Pattern.compile("\t*<[-\\w]+:[-\\w]+ .");
    private List<String> _allFileNames;
    private final Map<String, Map<String, String>> _classSetMethodsMap = new HashMap<String, Map<String, String>>();
    private Set<String> _primitiveTagAttributeDataTypes;
    private Map<String, Map<String, String>> _tagSetMethodsMap;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected TagAttributesCheck.Tag doFormatLineBreaks(TagAttributesCheck.Tag tag, String absolutePath) {
        String tagName = tag.getName();
        if (!tagName.contains(":") || tagName.startsWith("aui:") || tagName.startsWith("c:") || tagName.startsWith("portlet:") || ArrayUtil.contains(_SINGLE_LINE_TAG_WHITELIST, tagName)) {
            tag.setMultiLine(false);
        } else {
            tag.setMultiLine(true);
        }
        return tag;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this.formatIncorrectLineBreak(fileName, content);
        content = this._formatSingleLineTagAttributes(absolutePath, content);
        content = this.formatMultiLinesTagAttributes(absolutePath, content, false);
        return content;
    }

    @Override
    protected TagAttributesCheck.Tag formatTagAttributeType(TagAttributesCheck.Tag tag) throws Exception {
        Map<String, String> setMethodsMap = this._getSetMethodsMap(tag.getName());
        Map<String, String> attributesMap = tag.getAttributesMap();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String setAttributeMethodName;
            String dataType;
            String attributeValue = entry.getValue();
            String attributeName = entry.getKey();
            if (attributeValue.matches("<%= Boolean\\.(FALSE|TRUE) %>")) {
                attributeValue = StringUtil.replace(attributeValue, new String[]{"Boolean.FALSE", "Boolean.TRUE"}, new String[]{"false", "true"});
                tag.putAttribute(attributeName, attributeValue);
            }
            if (attributeValue.matches("<%=.*%>") || setMethodsMap == null || !this.isPortalSource() && !this.isSubrepository() || (dataType = setMethodsMap.get(setAttributeMethodName = "set" + TextFormatter.format(attributeName, 6))) == null) continue;
            Set<String> primitiveTagAttributeDataType = this._getPrimitiveTagAttributeDataTypes();
            if (primitiveTagAttributeDataType.contains(dataType)) {
                if (!this._isValidTagAttributeValue(attributeValue, dataType)) continue;
                tag.putAttribute(attributeName, "<%= " + attributeValue + " %>");
            }
            if (!dataType.equals("java.lang.String") && !dataType.equals("String")) continue;
            attributeValue = StringUtil.replace(attributeValue, new String[]{"=\"false\"", "=\"true\""}, new String[]{"=\"<%= Boolean.FALSE.toString() %>\"", "=\"<%= Boolean.TRUE.toString() %>\""});
            tag.putAttribute(attributeName, attributeValue);
        }
        return tag;
    }

    private String _formatSingleLineTagAttributes(String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String htmlTag;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.matches("<\\w+ .*>.*") && (htmlTag = this._getTag(trimmedLine, 0)) != null) {
                    String newHTMLTag = this.formatTagAttributes(absolutePath, htmlTag, false, true);
                    line = StringUtil.replace(line, htmlTag, newHTMLTag);
                }
                for (String jspTag : this._getJSPTag(line)) {
                    boolean forceSingleLine = false;
                    if (!line.equals(jspTag)) {
                        forceSingleLine = true;
                    }
                    String newJSPTag = this.formatTagAttributes(absolutePath, jspTag, false, forceSingleLine);
                    line = StringUtil.replace(line, jspTag, newJSPTag);
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private List<String> _getJSPTag(String line) {
        ArrayList<String> jspTags = new ArrayList<String>();
        Matcher matcher = _jspTaglibPattern.matcher(line);
        while (matcher.find()) {
            String tag = this._getTag(line, matcher.start());
            if (tag == null) {
                return jspTags;
            }
            jspTags.add(tag);
        }
        return jspTags;
    }

    private synchronized Set<String> _getPrimitiveTagAttributeDataTypes() {
        if (this._primitiveTagAttributeDataTypes == null) {
            this._primitiveTagAttributeDataTypes = SetUtil.fromArray(new String[]{"java.lang.Boolean", "Boolean", "boolean", "java.lang.Double", "Double", "double", "java.lang.Integer", "Integer", "int", "java.lang.Long", "Long", "long"});
        }
        return this._primitiveTagAttributeDataTypes;
    }

    private synchronized Map<String, String> _getSetMethodsMap(String tagName) throws Exception {
        if (this._tagSetMethodsMap != null) {
            return this._tagSetMethodsMap.get(tagName);
        }
        this._tagSetMethodsMap = new HashMap<String, Map<String, String>>();
        List<String> tldFileNames = TaglibUtil.getTLDFileNames(this.getBaseDirName(), this._allFileNames, this.getSourceFormatterExcludes(), this.isPortalSource());
        if (tldFileNames.isEmpty()) {
            return this._tagSetMethodsMap.get(tagName);
        }
        String utilTaglibSrcDirName = TaglibUtil.getUtilTaglibSrcDirName(this.getBaseDirName());
        block0: for (String tldFileName : tldFileNames) {
            tldFileName = StringUtil.replace(tldFileName, '\\', '/');
            File tldFile = new File(tldFileName);
            String content = FileUtil.read(tldFile);
            Document document = SourceUtil.readXML(content);
            Element rootElement = document.getRootElement();
            Element shortNameElement = rootElement.element("short-name");
            String shortName = shortNameElement.getStringValue();
            List tagElements = rootElement.elements("tag");
            String srcDir = null;
            for (Element tagElement : tagElements) {
                Element tagClassElement = tagElement.element("tag-class");
                String tagClassName = tagClassElement.getStringValue();
                if (!tagClassName.startsWith("com.liferay")) continue;
                Element tagNameElement = tagElement.element("name");
                String curTagName = tagNameElement.getStringValue();
                if (this._tagSetMethodsMap.containsKey(shortName + ":" + curTagName)) continue;
                if (srcDir == null) {
                    if (tldFileName.contains("/src/")) {
                        srcDir = SourceUtil.getAbsolutePath(tldFile);
                        srcDir = srcDir.substring(0, srcDir.lastIndexOf("/src/")) + "/src/";
                    } else {
                        srcDir = utilTaglibSrcDirName;
                        if (Validator.isNull(srcDir)) continue block0;
                    }
                }
                StringBundler sb = new StringBundler(3);
                sb.append(srcDir);
                sb.append(StringUtil.replace(tagClassName, '.', '/'));
                sb.append(".java");
                Map<String, String> setMethodsMap = this._getSetMethodsMap(sb.toString(), utilTaglibSrcDirName);
                if (setMethodsMap.isEmpty()) continue;
                this._tagSetMethodsMap.put(shortName + ":" + curTagName, setMethodsMap);
            }
        }
        return this._tagSetMethodsMap.get(tagName);
    }

    private Map<String, String> _getSetMethodsMap(String tagFileName, String utilTaglibSrcDirName) throws IOException, ParseException {
        if (this._classSetMethodsMap.containsKey(tagFileName)) {
            return this._classSetMethodsMap.get(tagFileName);
        }
        HashMap<String, String> setMethodsMap = new HashMap<String, String>();
        File tagFile = new File(tagFileName);
        if (!tagFile.exists()) {
            return setMethodsMap;
        }
        String tagFileContent = FileUtil.read(tagFile);
        JavaClass javaClass = JavaClassParser.parseJavaClass(tagFileName, tagFileContent);
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            JavaSignature javaSignature;
            List<JavaParameter> javaParameters;
            JavaMethod javaMethod;
            String methodName;
            if (!javaTerm.isJavaMethod() || !(methodName = (javaMethod = (JavaMethod)javaTerm).getName()).startsWith("set") || (javaParameters = (javaSignature = javaMethod.getSignature()).getParameters()).size() != 1) continue;
            JavaParameter javaParameter = javaParameters.get(0);
            setMethodsMap.put(methodName, javaParameter.getParameterType());
        }
        List<String> extendedTagFileNames = TaglibUtil.getExtendedTagFileNames(javaClass, tagFileName, utilTaglibSrcDirName);
        for (String extendedTagFileName : extendedTagFileNames) {
            setMethodsMap.putAll(this._getSetMethodsMap(extendedTagFileName, utilTaglibSrcDirName));
        }
        this._classSetMethodsMap.put(tagFileName, setMethodsMap);
        return setMethodsMap;
    }

    private String _getTag(String s, int fromIndex) {
        String part;
        int x = fromIndex;
        do {
            if ((x = s.indexOf(">", x + 1)) != -1) continue;
            return null;
        } while (this.getLevel(part = s.substring(fromIndex, x + 1), "<", ">") != 0);
        return part;
    }

    private boolean _isValidTagAttributeValue(String value, String dataType) {
        if (dataType.endsWith("Boolean") || dataType.equals("boolean")) {
            return Validator.isBoolean(value);
        }
        if (dataType.endsWith("Double") || dataType.equals("double")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
        if (dataType.endsWith("Integer") || dataType.equals("int") || dataType.endsWith("Long") || dataType.equals("long")) {
            return Validator.isNumber(value);
        }
        return false;
    }
}

