/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaFinderCacheCheck
extends BaseFileCheck {
    private static final Pattern _fetchByPrimaryKeysMethodPattern = Pattern.compile("@Override\n\tpublic Map<(.+)> fetchByPrimaryKeys\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("FinderImpl.java") && content.contains("public static final FinderPath")) {
            this._checkFinderCacheInterfaceMethod(fileName, content);
            content = this._fixClearCache(fileName, content);
        }
        return content;
    }

    private void _checkFinderCacheInterfaceMethod(String fileName, String content) {
        Matcher matcher = _fetchByPrimaryKeysMethodPattern.matcher(content);
        if (!matcher.find()) {
            this.addMessage(fileName, "Missing override of BasePersistenceImpl.fetchByPrimaryKeys(Set<Serializable>)", "finderpath.markdown");
        }
    }

    private String _fixClearCache(String fileName, String content) {
        if (fileName.contains("/test/integration/") || fileName.contains("/testIntegration/java")) {
            content = StringUtil.removeSubstring(content, "FinderCacheUtil.clearCache();");
        }
        return content;
    }
}

