/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.util.List;

public class JavaStaticBlockCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = (JavaClass)javaTerm;
        String classContent = javaClass.getContent();
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        if (!this.isExcludedPath("javaterm.sort.excludes", absolutePath)) {
            classContent = this._sortStaticBlocks(classContent, childJavaTerms);
        }
        classContent = this._combineStaticBlocks(classContent, childJavaTerms);
        return classContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _combineStaticBlocks(String classContent, List<JavaTerm> childJavaTerms) {
        if (childJavaTerms.size() <= 1) {
            return classContent;
        }
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : childJavaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            if (previousJavaTerm.isJavaStaticBlock() && javaTerm.isJavaStaticBlock()) {
                classContent = StringUtil.replaceFirst(classContent, javaTerm.getContent(), "");
                return StringUtil.replaceFirst(classContent, previousJavaTerm.getContent(), this._getCombinedStaticBlocks(previousJavaTerm.getContent(), javaTerm.getContent()));
            }
            previousJavaTerm = javaTerm;
        }
        return classContent;
    }

    private String _getCombinedStaticBlocks(String staticBlockContent1, String staticBlockContent2) {
        int x = staticBlockContent1.lastIndexOf("}");
        x = staticBlockContent1.lastIndexOf("\n", x - 1);
        int y = staticBlockContent2.indexOf("{") + 1;
        return staticBlockContent1.substring(0, x + 1) + staticBlockContent2.substring(y);
    }

    private JavaTerm _getLastJavaTerm(Class<?> clazz, String accessModifier, boolean isStatic, List<JavaTerm> childJavaTerms) {
        for (int i = childJavaTerms.size() - 1; i >= 0; --i) {
            JavaTerm javaTerm = childJavaTerms.get(i);
            String javaTermAccessModifier = javaTerm.getAccessModifier();
            if (javaTerm.getClass() != clazz || !javaTermAccessModifier.equals(accessModifier) || javaTerm.isStatic() != isStatic) continue;
            return javaTerm;
        }
        return null;
    }

    private JavaTerm _getLastReferencedJavaTerm(String staticBlockContent, List<JavaTerm> childJavaTerms) {
        boolean containsMethodCall = false;
        for (JavaTerm javaTerm : childJavaTerms) {
            if (!javaTerm.isStatic() || !javaTerm.isJavaMethod() || !staticBlockContent.matches("[\\s\\S]*\\s" + javaTerm.getName() + "\\([\\s\\S]*")) continue;
            containsMethodCall = true;
            break;
        }
        for (int i = childJavaTerms.size() - 1; i >= 0; --i) {
            JavaTerm javaTerm;
            javaTerm = childJavaTerms.get(i);
            if (!javaTerm.isStatic() || !staticBlockContent.matches("[\\s\\S]*\\W" + javaTerm.getName() + "\\W[\\s\\S]*") || !javaTerm.isJavaClass() && (!javaTerm.isJavaVariable() || containsMethodCall)) continue;
            return javaTerm;
        }
        return null;
    }

    private String _sortStaticBlocks(String classContent, List<JavaTerm> childJavaTerms) {
        for (JavaTerm childJavaTerm : childJavaTerms) {
            if (!childJavaTerm.isJavaStaticBlock()) continue;
            String staticBlockContent = childJavaTerm.getContent();
            JavaTerm lastReferencedJavaTerm = this._getLastReferencedJavaTerm(staticBlockContent, childJavaTerms);
            JavaTerm lastJavaTerm = null;
            lastJavaTerm = lastReferencedJavaTerm == null ? this._getLastJavaTerm(JavaVariable.class, "private", true, childJavaTerms) : this._getLastJavaTerm(lastReferencedJavaTerm.getClass(), lastReferencedJavaTerm.getAccessModifier(), lastReferencedJavaTerm.isStatic(), childJavaTerms);
            if (lastJavaTerm == null) {
                return classContent;
            }
            String lastJavaTermContent = lastJavaTerm.getContent();
            if (classContent.contains(lastJavaTermContent + "\n" + staticBlockContent)) continue;
            classContent = StringUtil.removeSubstring(classContent, staticBlockContent + "\n");
            classContent = StringUtil.replace(classContent, lastJavaTermContent, lastJavaTermContent + "\n" + staticBlockContent);
            break;
        }
        return classContent;
    }
}

