/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesStylingCheck
extends BaseFileCheck {
    private static final Pattern _sqlPattern = Pattern.compile("\\s\\((.*) ~ (\".*\")\\) OR ");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = content.replaceAll("(\\A|\n)( *[\\w.-]+)(( +=)|(= +))(.*)(\\Z|\n)", "$1$2=$6$7");
        Matcher matcher = _sqlPattern.matcher(content);
        while (matcher.find()) {
            String sqlValue;
            int lineNumber = this.getLineNumber(content, matcher.start());
            String nextLine = StringUtil.trim(SourceUtil.getLine(content, lineNumber + 1));
            String nextSQLValue = this._getSQLValue(nextLine, matcher.group(1));
            if (nextSQLValue == null || (sqlValue = matcher.group(2)).compareTo(nextSQLValue) <= 0) continue;
            content = StringUtil.replaceFirst(content, nextSQLValue, sqlValue, this.getLineStartPos(content, lineNumber + 1));
            return StringUtil.replaceFirst(content, sqlValue, nextSQLValue, this.getLineStartPos(content, lineNumber));
        }
        return content;
    }

    private String _getSQLValue(String line, String columnName) {
        Pattern pattern = Pattern.compile("^\\(" + columnName + " ~ (\".*\")");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

