/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLCheckstyleFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException, IOException {
        if (fileName.endsWith("/checkstyle.xml") || fileName.endsWith("/checkstyle-jsp.xml")) {
            this._checkCheckstyleXML(fileName, content);
        }
        return content;
    }

    private void _checkCheckstyleXML(String fileName, String content) throws DocumentException, IOException {
        Document document = SourceUtil.readXML(content);
        this._checkOrder(fileName, document.getRootElement());
    }

    private void _checkOrder(String fileName, Element element) {
        this.checkElementOrder(fileName, element, "module", null, new ElementComparator());
        String moduleName = element.attributeValue("name");
        this.checkElementOrder(fileName, element, "message", moduleName, new ElementComparator("key"));
        this.checkElementOrder(fileName, element, "property", moduleName, new ElementComparator());
        for (Element moduleElement : element.elements("module")) {
            this._checkOrder(fileName, moduleElement);
        }
    }
}

