/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLSuppressionsFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (!fileName.endsWith("-suppressions.xml")) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        SuppressElementComparator suppressElementComparator = new SuppressElementComparator();
        this.checkElementOrder(fileName, rootElement, "suppress", null, suppressElementComparator);
        this.checkElementOrder(fileName, rootElement.element("checkstyle"), "suppress", "checkstyle", suppressElementComparator);
        this.checkElementOrder(fileName, rootElement.element("source-check"), "suppress", "source-check", suppressElementComparator);
        return content;
    }

    private class SuppressElementComparator
    extends ElementComparator {
        private SuppressElementComparator() {
        }

        @Override
        public String getElementName(Element suppressElement) {
            StringBundler sb = new StringBundler(3);
            sb.append(suppressElement.attributeValue("checks"));
            sb.append("#");
            sb.append(suppressElement.attributeValue("files"));
            return sb.toString();
        }
    }
}

