/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.StringConcatenationCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class AppendCheck
extends StringConcatenationCheck {
    private static final String _MSG_INCORRECT_LINE_BREAK = "line.break.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, "append");
        boolean previousParameterIsLiteralString = false;
        for (int i = 0; i < methodCallDetailASTList.size(); ++i) {
            DetailAST previousParameterDetailAST;
            DetailAST parameterDetailAST;
            String variableName;
            DetailAST methodCallDetailAST = methodCallDetailASTList.get(i);
            String variableTypeName = this.getVariableTypeName(methodCallDetailAST, variableName = this.getVariableName(methodCallDetailAST), false);
            if (!variableTypeName.equals("StringBundler") || (parameterDetailAST = this._getParameterDetailAST(methodCallDetailAST)) == null) continue;
            this._checkPlusOperator(parameterDetailAST);
            if (parameterDetailAST.getType() != 139) {
                previousParameterIsLiteralString = false;
                continue;
            }
            if (!previousParameterIsLiteralString) {
                previousParameterIsLiteralString = true;
                continue;
            }
            DetailAST previousMethodCallDetailAST = methodCallDetailASTList.get(i - 1);
            if (!variableName.equals(this.getVariableName(previousMethodCallDetailAST)) || this._containsMethodCall(detailAST, variableName, "setIndex", "setStringAt") || (previousParameterDetailAST = this._getParameterDetailAST(previousMethodCallDetailAST)) == null || previousParameterDetailAST.getType() != 139) continue;
            this._checkLiteralStrings(methodCallDetailAST, previousMethodCallDetailAST, parameterDetailAST.getText(), previousParameterDetailAST.getText());
        }
    }

    private void _checkLiteralStrings(DetailAST methodCallDetailAST, DetailAST previousMethodCallDetailAST, String literalStringValue, String previousLiteralStringValue) {
        if (this.getEndLineNumber(previousMethodCallDetailAST) != methodCallDetailAST.getLineNo() - 1) {
            return;
        }
        if ((previousLiteralStringValue = previousLiteralStringValue.substring(1, previousLiteralStringValue.length() - 1)).endsWith("\\n")) {
            return;
        }
        literalStringValue = literalStringValue.substring(1, literalStringValue.length() - 1);
        this.checkLiteralStringStartAndEndCharacter(previousLiteralStringValue, literalStringValue, previousMethodCallDetailAST.getLineNo());
        if (this._hasIncorrectLineBreaks(methodCallDetailAST) | this._hasIncorrectLineBreaks(previousMethodCallDetailAST)) {
            return;
        }
        if (literalStringValue.startsWith("<") || literalStringValue.endsWith(">") || previousLiteralStringValue.startsWith("<") || previousLiteralStringValue.endsWith(">")) {
            return;
        }
        String previousLine = this.getLine(previousMethodCallDetailAST.getLineNo() - 1);
        int previousLineLength = CommonUtil.lengthExpandedTabs((String)previousLine, (int)previousLine.length(), (int)this.getTabWidth());
        if (previousLineLength + literalStringValue.length() <= this.getMaxLineLength()) {
            this.log(methodCallDetailAST, "literal.string.combine", new Object[]{previousLiteralStringValue, literalStringValue});
        } else {
            int pos = this.getStringBreakPos(previousLiteralStringValue, literalStringValue, this.getMaxLineLength() - previousLineLength);
            if (pos != -1) {
                this.log(methodCallDetailAST, "literal.string.move", new Object[]{literalStringValue.substring(0, pos + 1)});
            }
        }
    }

    private void _checkPlusOperator(DetailAST parameterDetailAST) {
        if (parameterDetailAST.getType() != 125) {
            return;
        }
        List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(parameterDetailAST, true, 139);
        if (!literalStringDetailASTList.isEmpty()) {
            this.log(parameterDetailAST, "plus.incorrect", new Object[0]);
        }
    }

    private boolean _containsMethodCall(DetailAST detailAST, String variableName, String ... methodNames) {
        for (String methodName : methodNames) {
            List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, variableName, methodName);
            if (methodCallDetailASTList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getParameterDetailAST(DetailAST methodCallDetailAST) {
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        DetailAST exprDetailAST = elistDetailAST.findFirstToken(28);
        if (exprDetailAST == null) {
            return null;
        }
        return exprDetailAST.getFirstChild();
    }

    private boolean _hasIncorrectLineBreaks(DetailAST methodCallDetailAST) {
        if (this.getStartLineNumber(methodCallDetailAST) != this.getEndLineNumber(methodCallDetailAST)) {
            this.log(methodCallDetailAST, _MSG_INCORRECT_LINE_BREAK, new Object[0]);
            return true;
        }
        return false;
    }
}

