/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterCheckUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseCheck
extends AbstractCheck {
    protected static final int ALL_TYPES = -1;
    protected static final int[] ARITHMETIC_OPERATOR_TOKEN_TYPES = new int[]{127, 126, 128, 125, 60};
    protected static final int[] RELATIONAL_OPERATOR_TOKEN_TYPES = new int[]{116, 120, 118, 119, 117, 115};
    private JSONObject _attributesJSONObject = new JSONObjectImpl();
    private final Map<String, String> _attributeValueMap = new ConcurrentHashMap<String, String>();
    private final Map<String, List<String>> _attributeValuesMap = new ConcurrentHashMap<String, List<String>>();
    private JSONObject _excludesJSONObject = new JSONObjectImpl();
    private final Map<String, List<String>> _excludesValuesMap = new ConcurrentHashMap<String, List<String>>();

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setAttributes(String attributes) throws JSONException {
        this._attributesJSONObject = new JSONObjectImpl(attributes);
    }

    public void setExcludes(String excludes) throws JSONException {
        this._excludesJSONObject = new JSONObjectImpl(excludes);
    }

    public void visitToken(DetailAST detailAST) {
        if (!this.isAttributeValue("enabled", true)) {
            return;
        }
        if (!this.isAttributeValue("showDebugInformation")) {
            this.doVisitToken(detailAST);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.doVisitToken(detailAST);
        long endTime = System.currentTimeMillis();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DebugUtil.increaseProcessingTime(clazz.getSimpleName(), endTime - startTime);
    }

    protected abstract void doVisitToken(DetailAST var1);

    protected boolean equals(DetailAST detailAST1, DetailAST detailAST2) {
        return Objects.equals(detailAST1.toString(), detailAST2.toString());
    }

    protected String getAbsolutePath() {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        return SourceUtil.getAbsolutePath(fileName);
    }

    protected List<DetailAST> getAllChildTokens(DetailAST detailAST, boolean recursive, int ... tokenTypes) {
        return DetailASTUtil.getAllChildTokens(detailAST, recursive, tokenTypes);
    }

    protected String getAttributeValue(String attributeKey) {
        return this.getAttributeValue(attributeKey, "");
    }

    protected String getAttributeValue(String attributeKey, String defaultValue) {
        return SourceFormatterCheckUtil.getJSONObjectValue(this._attributesJSONObject, this._attributeValueMap, attributeKey, defaultValue, this.getAbsolutePath(), this.getBaseDirName());
    }

    protected List<String> getAttributeValues(String attributeKey) {
        return SourceFormatterCheckUtil.getJSONObjectValues(this._attributesJSONObject, attributeKey, this._attributeValuesMap, this.getAbsolutePath(), this.getBaseDirName());
    }

    protected String getBaseDirName() {
        return SourceFormatterCheckUtil.getJSONObjectValue(this._attributesJSONObject, this._attributeValueMap, "baseDirName", "", null, null, true);
    }

    protected int getEndLineNumber(DetailAST detailAST) {
        int endLineNumber = detailAST.getLineNo();
        for (DetailAST childDetailAST : this.getAllChildTokens(detailAST, true, -1)) {
            if (childDetailAST.getLineNo() <= endLineNumber) continue;
            endLineNumber = childDetailAST.getLineNo();
        }
        return endLineNumber;
    }

    protected CommonHiddenStreamToken getHiddenBefore(DetailAST detailAST) {
        CommonASTWithHiddenTokens commonASTWithHiddenTokens = (CommonASTWithHiddenTokens)detailAST;
        return commonASTWithHiddenTokens.getHiddenBefore();
    }

    protected List<String> getImportNames(DetailAST detailAST) {
        DetailAST rootDetailAST = detailAST;
        while (true) {
            if (rootDetailAST.getParent() != null) {
                rootDetailAST = rootDetailAST.getParent();
                continue;
            }
            if (rootDetailAST.getPreviousSibling() == null) break;
            rootDetailAST = rootDetailAST.getPreviousSibling();
        }
        ArrayList<String> importNamesList = new ArrayList<String>();
        DetailAST siblingDetailAST = rootDetailAST.getNextSibling();
        while (siblingDetailAST != null && siblingDetailAST.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)siblingDetailAST);
            importNamesList.add(importIdent.getText());
            siblingDetailAST = siblingDetailAST.getNextSibling();
        }
        return importNamesList;
    }

    protected List<DetailAST> getMethodCalls(DetailAST detailAST, String methodName) {
        return this.getMethodCalls(detailAST, null, methodName);
    }

    protected List<DetailAST> getMethodCalls(DetailAST detailAST, String className, String methodName) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<DetailAST> nameDetailASTList;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST == null || (nameDetailASTList = this.getAllChildTokens(dotDetailAST, false, 58)).size() != 2) continue;
            DetailAST classNameDetailAST = nameDetailASTList.get(0);
            DetailAST methodNameDetailAST = nameDetailASTList.get(1);
            String methodCallClassName = classNameDetailAST.getText();
            String methodCallMethodName = methodNameDetailAST.getText();
            if (className != null && !methodCallClassName.equals(className) || !methodCallMethodName.equals(methodName)) continue;
            list.add(methodCallDetailAST);
        }
        return list;
    }

    protected String getMethodName(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return null;
        }
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            DetailAST nameDetailAST = detailAST.findFirstToken(58);
            return nameDetailAST.getText();
        }
        List<DetailAST> nameDetailASTList = this.getAllChildTokens(dotDetailAST, false, 58);
        DetailAST methodNameDetailAST = nameDetailASTList.get(nameDetailASTList.size() - 1);
        return methodNameDetailAST.getText();
    }

    protected List<DetailAST> getParameterDefs(DetailAST detailAST) {
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return new ArrayList<DetailAST>();
        }
        DetailAST parametersDetailAST = detailAST.findFirstToken(20);
        return this.getAllChildTokens(parametersDetailAST, false, 21);
    }

    protected List<String> getParameterNames(DetailAST detailAST) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (DetailAST parameterDefinitionDetailAST : this.getParameterDefs(detailAST)) {
            DetailAST identDetailAST = parameterDefinitionDetailAST.findFirstToken(58);
            parameterNames.add(identDetailAST.getText());
        }
        return parameterNames;
    }

    protected DetailAST getParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (!ArrayUtil.contains(tokenTypes, parentDetailAST.getType())) continue;
            return parentDetailAST;
        }
        return null;
    }

    protected String getSignature(DetailAST detailAST) {
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return "";
        }
        StringBundler sb = new StringBundler();
        sb.append('(');
        DetailAST parametersDetailAST = detailAST.findFirstToken(20);
        List<DetailAST> parameterDefinitionDetailASTList = this.getAllChildTokens(parametersDetailAST, false, 21);
        if (parameterDefinitionDetailASTList.isEmpty()) {
            sb.append(')');
            return sb.toString();
        }
        for (DetailAST parameterDefinitionDetailAST : parameterDefinitionDetailASTList) {
            sb.append(this.getTypeName(parameterDefinitionDetailAST, true));
            sb.append(',');
        }
        sb.setIndex(sb.index() - 1);
        sb.append(')');
        return sb.toString();
    }

    protected int getStartLineNumber(DetailAST detailAST) {
        int startLineNumber = detailAST.getLineNo();
        for (DetailAST childDetailAST : this.getAllChildTokens(detailAST, true, -1)) {
            if (childDetailAST.getLineNo() >= startLineNumber) continue;
            startLineNumber = childDetailAST.getLineNo();
        }
        return startLineNumber;
    }

    protected String getTypeName(DetailAST detailAST, boolean includeTypeArguments) {
        DetailAST childDetailAST;
        if (detailAST == null) {
            return "";
        }
        DetailAST typeDetailAST = detailAST;
        if (detailAST.getType() != 13 && detailAST.getType() != 164) {
            typeDetailAST = detailAST.findFirstToken(13);
        }
        if ((childDetailAST = typeDetailAST.getFirstChild()) == null) {
            return "";
        }
        int arrayDimension = 0;
        while (childDetailAST.getType() == 17) {
            ++arrayDimension;
            childDetailAST = childDetailAST.getFirstChild();
        }
        StringBundler sb = new StringBundler(1 + arrayDimension);
        FullIdent typeIdent = FullIdent.createFullIdent((DetailAST)childDetailAST);
        sb.append(typeIdent.getText());
        for (int i = 0; i < arrayDimension; ++i) {
            sb.append("[]");
        }
        if (!includeTypeArguments) {
            return sb.toString();
        }
        DetailAST typeArgumentsDetailAST = typeDetailAST.findFirstToken(163);
        if (typeArgumentsDetailAST == null) {
            return sb.toString();
        }
        sb.append('<');
        List<DetailAST> typeArgumentDetailASTList = this.getAllChildTokens(typeArgumentsDetailAST, false, 164);
        for (DetailAST typeArgumentDetailAST : typeArgumentDetailASTList) {
            sb.append(this.getTypeName(typeArgumentDetailAST, true));
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append('>');
        return sb.toString();
    }

    protected List<DetailAST> getVariableCallerDetailASTList(DetailAST variableDefinitionDetailAST, String variableName) {
        ArrayList<DetailAST> variableCallerDetailASTList = new ArrayList<DetailAST>();
        DetailAST parentDetailAST = variableDefinitionDetailAST.getParent();
        boolean globalVariable = false;
        DetailAST rangeDetailAST = null;
        if (parentDetailAST.getType() == 6) {
            rangeDetailAST = parentDetailAST;
            globalVariable = true;
        } else if (parentDetailAST.getType() == 7) {
            rangeDetailAST = parentDetailAST;
        } else {
            if (parentDetailAST.getType() != 96) {
                parentDetailAST = parentDetailAST.getParent();
            }
            rangeDetailAST = parentDetailAST.getLastChild();
        }
        if (rangeDetailAST.getType() != 6 && rangeDetailAST.getType() != 7) {
            return variableCallerDetailASTList;
        }
        List<DetailAST> nameDetailASTList = this.getAllChildTokens(rangeDetailAST, true, 58);
        for (DetailAST nameDetailAST : nameDetailASTList) {
            if (!variableName.equals(nameDetailAST.getText()) || (parentDetailAST = nameDetailAST.getParent()).getType() == 27 || parentDetailAST.getType() == 21 || parentDetailAST.getType() == 10) continue;
            if (parentDetailAST.getType() == 59) {
                if (!globalVariable && !this.equals(parentDetailAST.getFirstChild(), nameDetailAST)) continue;
                variableCallerDetailASTList.add(nameDetailAST);
                continue;
            }
            variableCallerDetailASTList.add(nameDetailAST);
        }
        return variableCallerDetailASTList;
    }

    protected String getVariableName(DetailAST methodCallDetailAST) {
        DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return null;
        }
        DetailAST nameDetailAST = dotDetailAST.findFirstToken(58);
        if (nameDetailAST == null) {
            return null;
        }
        return nameDetailAST.getText();
    }

    protected DetailAST getVariableTypeDetailAST(DetailAST detailAST, String variableName) {
        DetailAST previousDetailAST = detailAST;
        while (true) {
            DetailAST previousSiblingDetailAST;
            if (previousDetailAST.getType() == 14 || previousDetailAST.getType() == 154 || previousDetailAST.getType() == 15) {
                DetailAST objBlockDetailAST = previousDetailAST.findFirstToken(6);
                Iterator<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 10);
                Iterator<DetailAST> iterator = variableDefinitionDetailASTList.iterator();
                while (iterator.hasNext()) {
                    DetailAST variableDefinitionDetailAST = iterator.next();
                    if (!variableName.equals(this._getVariableName(variableDefinitionDetailAST))) continue;
                    return variableDefinitionDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 156 || previousDetailAST.getType() == 35) {
                List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(previousDetailAST, false, 10);
                for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
                    if (!variableName.equals(this._getVariableName(variableDefinitionDetailAST))) continue;
                    return variableDefinitionDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 96 || previousDetailAST.getType() == 20) {
                List<DetailAST> parameterDefinitionDetailASTList = this.getAllChildTokens(previousDetailAST, false, 21);
                for (DetailAST parameterDefinitionDetailAST : parameterDefinitionDetailASTList) {
                    if (!variableName.equals(this._getVariableName(parameterDefinitionDetailAST))) continue;
                    return parameterDefinitionDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 176) {
                DetailAST recourcesDetailAST = previousDetailAST.findFirstToken(177);
                List<DetailAST> resourceDetailASTList = this.getAllChildTokens(recourcesDetailAST, false, 178);
                for (DetailAST resourceDetailAST : resourceDetailASTList) {
                    if (!variableName.equals(this._getVariableName(resourceDetailAST))) continue;
                    return resourceDetailAST.findFirstToken(13);
                }
            } else if (previousDetailAST.getType() == 10 && variableName.equals(this._getVariableName(previousDetailAST))) {
                return previousDetailAST.findFirstToken(13);
            }
            if ((previousSiblingDetailAST = previousDetailAST.getPreviousSibling()) != null) {
                previousDetailAST = previousSiblingDetailAST;
                continue;
            }
            DetailAST parentDetailAST = previousDetailAST.getParent();
            if (parentDetailAST == null) break;
            previousDetailAST = parentDetailAST;
        }
        return null;
    }

    protected String getVariableTypeName(DetailAST detailAST, String variableName, boolean includeTypeArguments) {
        return this.getTypeName(this.getVariableTypeDetailAST(detailAST, variableName), includeTypeArguments);
    }

    protected boolean hasParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        DetailAST parentDetailAST = this.getParentWithTokenType(detailAST, tokenTypes);
        return parentDetailAST != null;
    }

    protected boolean isArray(DetailAST detailAST) {
        if (detailAST.getType() != 13) {
            return false;
        }
        DetailAST arrayDeclaratorDetailAST = detailAST.findFirstToken(17);
        return arrayDeclaratorDetailAST != null;
    }

    protected boolean isAtLineEnd(DetailAST detailAST, String line) {
        String text = detailAST.getText();
        return line.endsWith(text) && detailAST.getColumnNo() + text.length() == line.length();
    }

    protected boolean isAtLineStart(DetailAST detailAST, String line) {
        for (int i = 0; i < detailAST.getColumnNo(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    protected boolean isAttributeValue(String attributeKey) {
        return GetterUtil.getBoolean(this.getAttributeValue(attributeKey));
    }

    protected boolean isAttributeValue(String attributeKey, boolean defaultValue) {
        String attributeValue = this.getAttributeValue(attributeKey);
        if (Validator.isNull(attributeValue)) {
            return defaultValue;
        }
        return GetterUtil.getBoolean(attributeValue);
    }

    protected boolean isCollection(DetailAST detailAST) {
        if (detailAST.getType() != 13) {
            return false;
        }
        DetailAST typeArgumentsDetailAST = detailAST.findFirstToken(163);
        if (typeArgumentsDetailAST == null) {
            return false;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        return name.matches(".*(Collection|List|Map|Set)");
    }

    protected boolean isExcludedPath(String key) {
        return SourceFormatterCheckUtil.isExcludedPath(this._excludesJSONObject, this._excludesValuesMap, key, this.getAbsolutePath(), -1, null, this.getBaseDirName());
    }

    private String _getVariableName(DetailAST variableDefinitionDetailAST) {
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        return nameDetailAST.getText();
    }
}

