/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.ChainedMethodCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Objects;

public class JSONUtilCheck
extends ChainedMethodCheck {
    private static final String _MSG_USE_JSON_UTIL_PUT = "json.util.put.use";
    private static final String _MSG_USE_JSON_UTIL_PUT_ALL = "json.util.put.all.use";

    public int[] getDefaultTokens() {
        return new int[]{80, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 27) {
            this._checkChainedPutCalls(detailAST);
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28 && parentDetailAST.getType() != 10) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        DetailAST methodCallDetailAST = this._getMethodCallDetailAST(detailAST, parentDetailAST);
        if (methodCallDetailAST == null) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() > 0) {
            return;
        }
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        FullIdent fullIdent1 = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        String methodName = fullIdent1.getText();
        if (!methodName.equals("JSONFactoryUtil.createJSONArray") && !methodName.equals("JSONFactoryUtil.createJSONObject")) {
            return;
        }
        String variableName = this.getVariableName(detailAST, parentDetailAST);
        if (variableName == null) {
            return;
        }
        do {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                return;
            }
            FullIdent fullIdent2 = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, "put");
            if (fullIdent2 == null) continue;
            this.log(detailAST, _MSG_USE_JSON_UTIL_PUT, new Object[]{methodName, fullIdent1.getLineNo(), variableName + ".put", fullIdent2.getLineNo(), "JSONUtil.put"});
        } while (!this.containsVariableName(nextSiblingDetailAST, variableName));
    }

    private void _checkChainedPutCalls(DetailAST methodCallDetailAST) {
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        if (!Objects.equals(fullIdent.getText(), "JSONUtil.put")) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() != 1) {
            return;
        }
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 59) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 27) {
            return;
        }
        DetailAST nextSiblingDetailAST = methodCallDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() == 58 && Objects.equals(nextSiblingDetailAST.getText(), "put")) {
            this.log(methodCallDetailAST, _MSG_USE_JSON_UTIL_PUT_ALL, new Object[0]);
        }
    }

    private DetailAST _getMethodCallDetailAST(DetailAST assignDetailAST, DetailAST parentDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST != null && assignValueDetailAST.getType() == 27) {
            return assignValueDetailAST;
        }
        return null;
    }
}

