/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableNameCheck
extends BaseCheck {
    protected static final String MSG_RENAME_VARIABLE = "variable.rename";
    private static final String[][] _ALL_CAPS_STRINGS = new String[][]{{"DDL", "Ddl"}, {"DDM", "Ddm"}, {"DL", "Dl"}, {"PK", "Pk"}};
    private static final String _ALLOWED_VARIABLE_NAMES_KEY = "allowedVariableNames";
    private static final String _ENFORCE_TYPE_NAMES_KEY = "enforceTypeNames";
    private static final String _MSG_INCORRECT_ENDING_VARIABLE = "variable.incorrect.ending";
    private static final String _MSG_TYPO_VARIABLE = "variable.typo";
    private static final Pattern _isVariableNamePattern = Pattern.compile("(_?)(is|IS_)([A-Z])(.*)");

    public int[] getDefaultTokens() {
        return new int[]{21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST;
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST.branchContains(63) || modifiersDetailAST.branchContains(62)) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        this._checkCaps(detailAST, name);
        this._checkIsVariableName(detailAST, name);
        DetailAST typeDetailAST = detailAST.findFirstToken(13);
        DetailAST firstChildDetailAST = typeDetailAST.getFirstChild();
        if (firstChildDetailAST == null) {
            return;
        }
        if (firstChildDetailAST.getType() == 58) {
            String typeName = firstChildDetailAST.getText();
            this._checkExceptionVariableName(detailAST, name, typeName);
            this._checkInstanceVariableName(detailAST, name, typeName);
            this._checkTypeName(detailAST, name, typeName);
            this._checkTypo(detailAST, name, typeName);
        }
        if ((parentDetailAST = this.getParentWithTokenType(detailAST, 14, 8, 9)) == null) {
            return;
        }
        List<DetailAST> assignDetailASTList = this.getAllChildTokens(parentDetailAST, true, 80);
        for (DetailAST assignDetailAST : assignDetailASTList) {
            DetailAST nextSiblingDetailAST;
            firstChildDetailAST = assignDetailAST.getFirstChild();
            if (firstChildDetailAST == null) continue;
            String methodName = "";
            if (this.equals(assignDetailAST.getParent(), detailAST)) {
                if (firstChildDetailAST.getType() != 28) continue;
                if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 27) {
                    methodName = this.getMethodName(firstChildDetailAST);
                }
            } else if (firstChildDetailAST.getType() == 58 && name.equals(firstChildDetailAST.getText()) && (nextSiblingDetailAST = firstChildDetailAST.getNextSibling()).getType() == 27) {
                methodName = this.getMethodName(nextSiblingDetailAST);
            }
            if (!methodName.matches("get[A-Z].*")) continue;
            this._checkTypo(detailAST, name, methodName.substring(3));
        }
    }

    protected String getExpectedVariableName(String typeName) {
        if (StringUtil.isUpperCase(typeName) || typeName.matches("[A-Z]+s")) {
            return StringUtil.toLowerCase(typeName);
        }
        if (typeName.startsWith("IDf")) {
            return StringUtil.replaceFirst(typeName, "IDf", "idf");
        }
        if (typeName.startsWith("OSGi")) {
            return StringUtil.replaceFirst(typeName, "OSGi", "osgi");
        }
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            if (i == 0) {
                return typeName;
            }
            if (i == 1) {
                return StringUtil.toLowerCase(typeName.substring(0, 1)) + typeName.substring(1);
            }
            return StringUtil.toLowerCase(typeName.substring(0, i - 1)) + typeName.substring(i - 1);
        }
        return StringUtil.toLowerCase(typeName);
    }

    private void _checkCaps(DetailAST detailAST, String name) {
        for (String[] array : _ALL_CAPS_STRINGS) {
            String s = array[1];
            int x = -1;
            while ((x = name.indexOf(s, x + 1)) != -1) {
                int y = x + s.length();
                if (y != name.length() && !Character.isUpperCase(name.charAt(y))) continue;
                String newName = name.substring(0, x) + array[0] + name.substring(y);
                this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, newName});
            }
        }
    }

    private void _checkExceptionVariableName(DetailAST detailAST, String name, String typeName) {
        String expectedName;
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 96 || detailAST.getType() != 21 || !typeName.endsWith("Exception")) {
            return;
        }
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.endsWith("ExceptionMapper.java") && !name.equals(expectedName = this.getExpectedVariableName(typeName))) {
            this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, expectedName});
        }
    }

    private void _checkInstanceVariableName(DetailAST detailAST, String name, String typeName) {
        if (!name.contentEquals("_instance")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        while (true) {
            if (parentDetailAST == null) {
                return;
            }
            if (parentDetailAST.getType() == 14) break;
            parentDetailAST = parentDetailAST.getParent();
        }
        DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
        if (!typeName.equals(identDetailAST.getText())) {
            return;
        }
        DetailAST grandParentDetailAST = parentDetailAST.getParent();
        if (grandParentDetailAST != null) {
            return;
        }
        String expectedVariableName = this._getExpectedVariableName(typeName, "_", "");
        List<DetailAST> variableDeclarationDetailASTList = this.getAllChildTokens(parentDetailAST, true, 10);
        for (DetailAST variableDeclarationDetailAST : variableDeclarationDetailASTList) {
            identDetailAST = variableDeclarationDetailAST.findFirstToken(58);
            if (!expectedVariableName.equals(identDetailAST.getText())) continue;
            return;
        }
        this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, expectedVariableName});
    }

    private void _checkIsVariableName(DetailAST detailAST, String name) {
        if (!this._isBooleanType(detailAST.findFirstToken(13))) {
            return;
        }
        Matcher matcher = _isVariableNamePattern.matcher(name);
        if (!matcher.find()) {
            return;
        }
        String group2 = matcher.group(2);
        String newName = null;
        if (group2.equals("is")) {
            newName = StringUtil.toLowerCase(matcher.group(3)) + matcher.group(4);
            if (!Validator.isVariableName(newName)) {
                return;
            }
            newName = matcher.group(1) + newName;
        } else {
            newName = matcher.group(1) + matcher.group(3) + matcher.group(4);
        }
        if (!this._classHasVariableWithName(detailAST, newName)) {
            this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, newName});
        }
    }

    private void _checkTypeName(DetailAST detailAST, String variableName, String typeName) {
        List<String> enforceTypeNames = this.getAttributeValues(_ENFORCE_TYPE_NAMES_KEY);
        if ((typeName.endsWith("Impl") || enforceTypeNames.contains(typeName)) && !variableName.matches("(?i).*" + typeName + "[0-9]*")) {
            this.log(detailAST, _MSG_INCORRECT_ENDING_VARIABLE, new Object[]{typeName, this.getExpectedVariableName(typeName)});
        }
    }

    private void _checkTypo(DetailAST detailAST, String variableName, String typeName) {
        String typeNameTrailingDigits;
        String trimmedTypeName;
        String expectedName;
        if (StringUtil.isUpperCase(variableName) || typeName.contains("_")) {
            return;
        }
        List<String> allowedVariableNames = this.getAttributeValues(_ALLOWED_VARIABLE_NAMES_KEY);
        if (allowedVariableNames.contains(variableName)) {
            return;
        }
        String nameTrailingDigits = this._getTrailingDigits(variableName);
        String trimmedName = StringUtil.replaceLast(variableName, nameTrailingDigits, "");
        String leadingUnderline = "";
        if (variableName.startsWith("_")) {
            leadingUnderline = "_";
            trimmedName = trimmedName.substring(1);
        }
        if (StringUtil.equals(trimmedName, expectedName = this.getExpectedVariableName(trimmedTypeName = StringUtil.replaceLast(typeName, typeNameTrailingDigits = this._getTrailingDigits(typeName), "")))) {
            return;
        }
        if (StringUtil.equalsIgnoreCase(trimmedName, trimmedTypeName)) {
            for (int i = expectedName.length() - 1; i >= 0; --i) {
                char c1 = trimmedName.charAt(i);
                if (c1 == expectedName.charAt(i) || i >= expectedName.length() - 1) continue;
                char c2 = trimmedName.charAt(i + 1);
                if (!Character.isUpperCase(c1) || !Character.isDigit(c2) && !Character.isUpperCase(c2)) continue;
                return;
            }
            this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, StringBundler.concat(leadingUnderline, expectedName, nameTrailingDigits)});
            return;
        }
        trimmedName = StringUtil.toLowerCase(trimmedName);
        trimmedTypeName = StringUtil.toLowerCase(trimmedTypeName);
        if (trimmedName.charAt(0) != trimmedTypeName.charAt(0) || trimmedName.charAt(trimmedName.length() - 1) != trimmedTypeName.charAt(trimmedTypeName.length() - 1)) {
            return;
        }
        int min = Math.min(trimmedName.length(), trimmedTypeName.length());
        int diff = Math.abs(trimmedName.length() - trimmedTypeName.length());
        if (min < 5 || diff > 1) {
            return;
        }
        int i = StringUtil.startsWithWeight(trimmedName, trimmedTypeName);
        if ((trimmedName = trimmedName.substring(i)).startsWith("_")) {
            return;
        }
        trimmedTypeName = trimmedTypeName.substring(i);
        for (int j = 1; j <= trimmedName.length() && j <= trimmedTypeName.length(); ++j) {
            if (trimmedName.charAt(trimmedName.length() - j) == trimmedTypeName.charAt(trimmedTypeName.length() - j)) continue;
            if (this._containSameCharacters(trimmedName, trimmedTypeName)) break;
            return;
        }
        this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, this._getExpectedVariableName(typeName, leadingUnderline, nameTrailingDigits)});
    }

    private boolean _classHasVariableWithName(DetailAST detailAST, String variableName) {
        ArrayList<DetailAST> definitionDetailASTList = new ArrayList<DetailAST>();
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() == 9) {
                definitionDetailASTList.addAll(this.getAllChildTokens(parentDetailAST, true, 21, 10));
            }
            if (parentDetailAST.getType() != 14) continue;
            DetailAST objBlockDetailAST = parentDetailAST.findFirstToken(6);
            definitionDetailASTList.addAll(this.getAllChildTokens(objBlockDetailAST, false, 10));
        }
        for (DetailAST definitionDetailAST : definitionDetailASTList) {
            DetailAST definitionNameDetailAST = definitionDetailAST.findFirstToken(58);
            if (!variableName.equals(definitionNameDetailAST.getText())) continue;
            return true;
        }
        return false;
    }

    private boolean _containSameCharacters(String s1, String s2) {
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        Arrays.sort(chars1);
        Arrays.sort(chars2);
        return Arrays.equals(chars1, chars2);
    }

    private String _getExpectedVariableName(String typeName, String leadingUnderline, String trailingDigits) {
        return StringBundler.concat(leadingUnderline, this.getExpectedVariableName(typeName), trailingDigits);
    }

    private String _getTrailingDigits(String s) {
        String digits = "";
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(s.charAt(i))) {
                return digits;
            }
            digits = s.charAt(i) + digits;
        }
        return digits;
    }

    private boolean _isBooleanType(DetailAST typeDetailAST) {
        String name;
        DetailAST childDetailAST = typeDetailAST.getFirstChild();
        if (childDetailAST == null) {
            return false;
        }
        if (childDetailAST.getType() == 50) {
            return true;
        }
        return childDetailAST.getType() == 58 && (name = childDetailAST.getText()).equals("Boolean");
    }
}

