/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSettings {
    private static final Pattern _contentDirPattern = Pattern.compile("\\scontent=(.*?)(,\\\\|\n|$)");
    private static final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _exportPackagePattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _releaseVersionPattern = Pattern.compile("Bundle-Version: (.*)(\n|\\Z)");
    private final String _content;
    private List<String> _exportPackageNames;
    private final String _fileName;
    private Properties _languageProperties;
    private String _releaseVersion;

    public BNDSettings(String fileName, String content) {
        this._fileName = fileName;
        this._content = content;
    }

    public String getContent() {
        return this._content;
    }

    public List<String> getExportPackageNames() throws IOException {
        if (this._exportPackageNames != null) {
            return this._exportPackageNames;
        }
        ArrayList<String> exportPackageNames = new ArrayList<String>();
        Matcher matcher = _exportPackagePattern.matcher(this._content);
        if (!matcher.find()) {
            this._exportPackageNames = exportPackageNames;
            return exportPackageNames;
        }
        for (String line : StringUtil.splitLines(matcher.group(3))) {
            if (Validator.isNull(line = StringUtil.trim(line)) || line.equals("\\")) continue;
            if ((line = StringUtil.removeSubstring(line, ",\\")).indexOf(";") != -1) {
                line = line.substring(0, line.indexOf(";"));
            }
            exportPackageNames.add(line);
        }
        matcher = _exportContentsPattern.matcher(this._content);
        if (!matcher.find()) {
            this._exportPackageNames = exportPackageNames;
            return exportPackageNames;
        }
        for (String line : StringUtil.splitLines(matcher.group(3))) {
            if (Validator.isNull(line = StringUtil.trim(line)) || line.equals("\\")) continue;
            if ((line = StringUtil.removeSubstring(line, ",\\")).indexOf(";") != -1) {
                line = line.substring(0, line.indexOf(";"));
            }
            exportPackageNames.add(line);
        }
        this._exportPackageNames = exportPackageNames;
        return exportPackageNames;
    }

    public String getFileName() {
        return this._fileName;
    }

    public Properties getLanguageProperties() throws IOException {
        int pos;
        File file;
        if (this._languageProperties != null) {
            return this._languageProperties;
        }
        if (this._content.matches("[\\s\\S]*Provide-Capability:[\\s\\S]*liferay\\.resource\\.bundle[\\s\\S]*") || this._content.matches("[\\s\\S]*-liferay-aggregate-resource-bundles:[\\s\\S]*")) {
            return null;
        }
        Properties languageProperties = new Properties();
        Matcher matcher = _contentDirPattern.matcher(this._content);
        if (matcher.find() && (file = new File(this._fileName.substring(0, (pos = this._fileName.lastIndexOf(47)) + 1) + matcher.group(1) + "/Language.properties")).exists()) {
            languageProperties.load(new FileInputStream(file));
        }
        this._languageProperties = languageProperties;
        return this._languageProperties;
    }

    public String getReleaseVersion() {
        if (this._releaseVersion != null) {
            return this._releaseVersion;
        }
        Matcher matcher = _releaseVersionPattern.matcher(this._content);
        if (!matcher.find()) {
            return null;
        }
        this._releaseVersion = matcher.group(1);
        return this._releaseVersion;
    }
}

