/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class JSONIndentationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int expectedTabCount = 0;
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this._fixIndentation(line, expectedTabCount));
                sb.append("\n");
                expectedTabCount = this.getLevel(line, new String[]{"[", "{"}, new String[]{"]", "}"}, expectedTabCount);
            }
        }
        String newContent = StringUtil.trimTrailing(sb.toString());
        if (fileName.endsWith("/package.json") && newContent.equals(StringUtil.trimTrailing(content))) {
            return content;
        }
        return newContent;
    }

    private String _fixIndentation(String line, int expectedTabCount) {
        if (Validator.isNull(line)) {
            return line;
        }
        int leadingTabCount = this.getLeadingTabCount(line);
        if (line.matches("\t*[\\}\\]].*")) {
            --expectedTabCount;
        }
        if (leadingTabCount == expectedTabCount) {
            return line;
        }
        String expectedTab = new String(new char[expectedTabCount]);
        return StringUtil.replace(expectedTab, "\u0000", "\t") + StringUtil.trimLeading(line);
    }
}

