/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLFriendlyURLRoutesFileCheck
extends BaseFileCheck {
    private static final Pattern _doctypePattern = Pattern.compile("DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL Routes ([0-9]+)\\.[0-9]+\\.[0-9]+//EN\" \"http://www.liferay.com/dtd/liferay-friendly-url-routes_([0-9]+)_[0-9]+_[0-9]+\\.dtd");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith("routes.xml")) {
            this._checkDTDVersion(fileName, content);
            this._checkOrder(fileName, content);
        }
        return content;
    }

    private void _checkDTDVersion(String fileName, String content) {
        Matcher matcher = _doctypePattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String mainMajorReleaseVersion = this._getMainMajorReleaseVersion();
        if (!mainMajorReleaseVersion.equals(matcher.group(1)) || !mainMajorReleaseVersion.equals(matcher.group(2))) {
            this.addMessage(fileName, "Major version for dtd should be '" + mainMajorReleaseVersion + "'", this.getLineNumber(content, matcher.start()));
        }
    }

    private void _checkOrder(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List routeElements = rootElement.elements("route");
        ElementComparator elementComparator = new ElementComparator();
        for (Element routeElement : routeElements) {
            this.checkElementOrder(fileName, routeElement, "ignored-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "implicit-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "overridden-parameter", null, elementComparator);
        }
    }

    private String _getMainMajorReleaseVersion() {
        String releaseVersion = ReleaseInfo.getVersion();
        int pos = releaseVersion.indexOf(46);
        return releaseVersion.substring(0, pos);
    }
}

