/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLLookAndFeelFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith("-look-and-feel.xml")) {
            this._checkLookAndFeelXML(fileName, content);
        }
        return content;
    }

    private void _checkLookAndFeelXML(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List themeElements = rootElement.elements("theme");
        for (Element themeElement : themeElements) {
            this.checkElementOrder(fileName, themeElement, "portlet-decorator", null, new ElementComparator("id"));
            Element settingsElement = themeElement.element("settings");
            this.checkElementOrder(fileName, settingsElement, "setting", null, new ElementComparator("key"));
        }
    }
}

