/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceUtil
extends SourceUtil {
    private static final Pattern _packagePattern = Pattern.compile("(\n|^)\\s*package (.*);\n");

    public static String getClassName(String fileName) {
        int x = fileName.lastIndexOf(47);
        int y = fileName.lastIndexOf(46);
        return fileName.substring(x + 1, y);
    }

    public static String getPackageName(String content) {
        Matcher matcher = _packagePattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static List<String> getParameterList(String methodCall) {
        String parameters = null;
        int x = -1;
        while (ToolsUtil.getLevel(parameters = methodCall.substring(0, (x = methodCall.indexOf(")", x + 1)) + 1), "(", ")") != 0 || ToolsUtil.getLevel(parameters, "{", "}") != 0) {
        }
        x = parameters.indexOf("(");
        parameters = parameters.substring(x + 1, parameters.length() - 1);
        return JavaSourceUtil.splitParameters(parameters);
    }

    public static boolean isValidJavaParameter(String javaParameter) {
        if (javaParameter.contains(" implements ") || javaParameter.contains(" throws ")) {
            return false;
        }
        return ToolsUtil.getLevel(javaParameter, "(", ")") == 0 && ToolsUtil.getLevel(javaParameter, "<", ">") == 0 && ToolsUtil.getLevel(javaParameter, "{", "}") == 0;
    }

    public static List<String> splitParameters(String parameters) {
        ArrayList<String> parametersList = new ArrayList<String>();
        int x = -1;
        while (true) {
            String linePart;
            if ((x = parameters.indexOf(",", x + 1)) == -1) {
                parametersList.add(StringUtil.trim(parameters));
                return parametersList;
            }
            if (ToolsUtil.isInsideQuotes(parameters, x) || ToolsUtil.getLevel(linePart = parameters.substring(0, x), "(", ")") != 0 || ToolsUtil.getLevel(linePart, "{", "}") != 0) continue;
            parametersList.add(StringUtil.trim(linePart));
            parameters = parameters.substring(x + 1);
            x = -1;
        }
    }
}

