/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

@OSGiBeanProperties(service={InfrastructureUtil.class})
public class InfrastructureUtil {
    private static final Log _log = LogFactoryUtil.getLog(InfrastructureUtil.class);
    private static DataSource _dataSource;
    private static DynamicDataSourceTargetSource _dynamicDataSourceTargetSource;
    private static Session _mailSession;
    private static Object _transactionManager;

    public static DataSource getDataSource() {
        return _dataSource;
    }

    public static DynamicDataSourceTargetSource getDynamicDataSourceTargetSource() {
        return _dynamicDataSourceTargetSource;
    }

    public static Session getMailSession() {
        if (_mailSession == null) {
            _mailSession = InfrastructureUtil._createMailSession();
        }
        return _mailSession;
    }

    public static Object getTransactionManager() {
        return _transactionManager;
    }

    public void setDataSource(DataSource dataSource) {
        _dataSource = dataSource;
    }

    public void setDynamicDataSourceTargetSource(DynamicDataSourceTargetSource dynamicDataSourceTargetSource) {
        _dynamicDataSourceTargetSource = dynamicDataSourceTargetSource;
    }

    @Deprecated
    public void setMailSession(Session mailSession) {
    }

    public void setTransactionManager(Object transactionManager) {
        _transactionManager = transactionManager;
    }

    private static Session _createMailSession() {
        Properties properties = PropsUtil.getProperties("mail.session.", true);
        String jndiName = properties.getProperty("jndi.name");
        if (Validator.isNotNull(jndiName)) {
            try {
                Properties jndiEnvironmentProperties = PropsUtil.getProperties("jndi.environment.", true);
                InitialContext context = new InitialContext(jndiEnvironmentProperties);
                return (Session)JNDIUtil.lookup((Context)context, (String)jndiName);
            }
            catch (Exception exception) {
                _log.error("Unable to lookup " + jndiName, exception);
            }
        }
        return Session.getInstance((Properties)properties);
    }
}

