/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ThreadLocalDistributorRegistry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ThreadLocalDistributor
implements Externalizable {
    private static final Log _log = LogFactoryUtil.getLog(ThreadLocalDistributor.class);
    private ClassLoader _classLoader;
    private int _index;
    private List<ThreadLocal<Serializable>> _threadLocals = new ArrayList<ThreadLocal<Serializable>>();
    private List<KeyValuePair> _threadLocalSources;
    private Serializable[] _threadLocalValues;

    public void afterPropertiesSet() throws Exception {
        if (this._threadLocalSources == null) {
            throw new IllegalArgumentException("Thread local sources is null");
        }
        ClassLoader classLoader = this.getClassLoader();
        for (KeyValuePair keyValuePair : this._threadLocalSources) {
            String className = keyValuePair.getKey();
            String fieldName = keyValuePair.getValue();
            Class<?> clazz = classLoader.loadClass(className);
            Field field = ReflectionUtil.getDeclaredField(clazz, fieldName);
            if (!ThreadLocal.class.isAssignableFrom(field.getType())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(fieldName + " is not of type ThreadLocal");
                continue;
            }
            if (!Modifier.isStatic(field.getModifiers())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(fieldName + " is not a static ThreadLocal");
                continue;
            }
            ThreadLocal threadLocal = (ThreadLocal)field.get(null);
            if (threadLocal == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(fieldName + " is not initialized");
                continue;
            }
            this._threadLocals.add(threadLocal);
        }
        this._threadLocalValues = new Serializable[this._threadLocals.size()];
        this._index = ThreadLocalDistributorRegistry.addThreadLocalDistributor(this);
    }

    public void capture() {
        for (int i = 0; i < this._threadLocalValues.length; ++i) {
            ThreadLocal<Serializable> threadLocal = this._threadLocals.get(i);
            this._threadLocalValues[i] = threadLocal.get();
        }
    }

    public ClassLoader getClassLoader() {
        if (this._classLoader == null) {
            Thread currentThread = Thread.currentThread();
            this._classLoader = currentThread.getContextClassLoader();
        }
        return this._classLoader;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._index = objectInput.readInt();
        this._threadLocalValues = (Serializable[])objectInput.readObject();
        ThreadLocalDistributor threadLocalDistributor = ThreadLocalDistributorRegistry.getThreadLocalDistributor(this._index);
        this._threadLocals = threadLocalDistributor._threadLocals;
    }

    public void restore() {
        for (int i = 0; i < this._threadLocalValues.length; ++i) {
            ThreadLocal<Serializable> threadLocal = this._threadLocals.get(i);
            threadLocal.set(this._threadLocalValues[i]);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setThreadLocalSources(List<KeyValuePair> threadLocalSources) {
        this._threadLocalSources = threadLocalSources;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this._index);
        objectOutput.writeObject(this._threadLocalValues);
    }
}

