/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TryWithResourcesCheck
extends BaseCheck {
    private static final String _MSG_USE_TRY_WITH_RESOURCES = "try.with.resources.use";
    private Tuple _closeableTypeNamesTuple;

    public int[] getDefaultTokens() {
        return new int[]{95};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST firstChildDetailAST;
        DetailAST literalFinallyDetailAST = detailAST.findFirstToken(97);
        if (literalFinallyDetailAST != null) {
            this._checkFinallyStatement(detailAST, literalFinallyDetailAST);
        }
        if ((firstChildDetailAST = detailAST.getFirstChild()).getType() == 176) {
            this._populateCloseableTypeNames(firstChildDetailAST);
        }
    }

    private void _checkFinallyStatement(DetailAST literalTryDetailAST, DetailAST literalFinallyDetailAST) {
        DetailAST slistDetailAST = literalFinallyDetailAST.findFirstToken(7);
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(slistDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            Tuple closeableTypeNamesTuple;
            List closeableTypeNames;
            DetailAST typeDetailAST;
            List<String> cleanUpVariableNames = this._getCleanUpVariableNames(methodCallDetailAST);
            for (String cleanUpVariableName : cleanUpVariableNames) {
                DetailAST typeDetailAST2;
                if (!this._useTryWithResources(cleanUpVariableName, typeDetailAST2 = this.getVariableTypeDetailAST(literalTryDetailAST, cleanUpVariableName, false), literalTryDetailAST)) continue;
                this.log(methodCallDetailAST, _MSG_USE_TRY_WITH_RESOURCES, new Object[]{cleanUpVariableName, "DataAccess.cleanUp"});
            }
            String closeVariableName = this._getCloseVariableName(methodCallDetailAST, literalFinallyDetailAST);
            if (closeVariableName == null || !this._useTryWithResources(closeVariableName, typeDetailAST = this.getVariableTypeDetailAST(literalTryDetailAST, closeVariableName, false), literalTryDetailAST) || !(closeableTypeNames = (List)(closeableTypeNamesTuple = this._getCloseableTypeNamesTuple()).getObject(0)).contains(this._getFullyQualifiedTypeName(typeDetailAST, true))) continue;
            this.log(methodCallDetailAST, _MSG_USE_TRY_WITH_RESOURCES, new Object[]{closeVariableName, closeVariableName + ".close"});
        }
    }

    private List<String> _getCleanUpVariableNames(DetailAST methodCallDetailAST) {
        ArrayList<String> variableNames = new ArrayList<String>();
        DetailAST dotDetailAST = methodCallDetailAST.getFirstChild();
        if (dotDetailAST.getType() != 59) {
            return variableNames;
        }
        DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
        if (!Objects.equals(lastChildDetailAST.getText(), "cleanUp")) {
            return variableNames;
        }
        DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
        if (!Objects.equals(firstChildDetailAST.getText(), "DataAccess")) {
            return variableNames;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 58) continue;
            variableNames.add(firstChildDetailAST.getText());
        }
        return variableNames;
    }

    private synchronized Tuple _getCloseableTypeNamesTuple() {
        if (this._closeableTypeNamesTuple != null) {
            return this._closeableTypeNamesTuple;
        }
        File closeableTypeNamesFile = SourceFormatterUtil.getFile(this.getBaseDirName(), "modules/util/source-formatter/src/main/resources/dependencies/closeable-type-names.txt", 7);
        String content = null;
        try {
            if (closeableTypeNamesFile != null) {
                content = FileUtil.read(closeableTypeNamesFile);
            } else {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                content = StringUtil.read(classLoader.getResourceAsStream("dependencies/closeable-type-names.txt"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._closeableTypeNamesTuple = new Tuple(ListUtil.fromString(content, ","), closeableTypeNamesFile);
        return this._closeableTypeNamesTuple;
    }

    private String _getCloseVariableName(DetailAST methodCallDetailAST, DetailAST literalFinallyDetailAST) {
        DetailAST dotDetailAST = methodCallDetailAST.getFirstChild();
        if (dotDetailAST.getType() != 59) {
            return null;
        }
        DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
        if (!Objects.equals(lastChildDetailAST.getText(), "close")) {
            return null;
        }
        DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 58) {
            return null;
        }
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return null;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 7) {
            return null;
        }
        String variableName = firstChildDetailAST.getText();
        if (this.equals(parentDetailAST = parentDetailAST.getParent(), literalFinallyDetailAST)) {
            return variableName;
        }
        if (parentDetailAST.getType() != 83) {
            return null;
        }
        DetailAST exprDetailAST = parentDetailAST.findFirstToken(28);
        firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 115) {
            return null;
        }
        lastChildDetailAST = firstChildDetailAST.getLastChild();
        if (lastChildDetailAST.getType() != 135) {
            return null;
        }
        if (!variableName.equals((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getText())) {
            return null;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 7) {
            return null;
        }
        if (this.equals(parentDetailAST = parentDetailAST.getParent(), literalFinallyDetailAST)) {
            return variableName;
        }
        return null;
    }

    private String _getFullyQualifiedTypeName(DetailAST typeDetailAST, boolean checkPackage) {
        String typeName = this.getTypeName(typeDetailAST, false);
        if (typeName.contains(".") && Character.isLowerCase(typeName.charAt(0))) {
            return typeName;
        }
        List<String> importNames = this.getImportNames(typeDetailAST);
        for (String importName : importNames) {
            int x;
            String className = importName.substring((x = importName.lastIndexOf(46)) + 1);
            if (typeName.equals(className)) {
                return importName;
            }
            if (!typeName.startsWith(className + ".")) continue;
            return StringUtil.replaceLast(importName, className, typeName);
        }
        if (!checkPackage) {
            return null;
        }
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        return JavaSourceUtil.getPackageName((String)fileText.getFullText()) + "." + typeName;
    }

    private void _populateCloseableTypeNames(DetailAST resourceSpecificationDetailAST) {
        Tuple closeableTypeNamesTuple = this._getCloseableTypeNamesTuple();
        File closeableTypeNamesFile = (File)closeableTypeNamesTuple.getObject(1);
        if (closeableTypeNamesFile == null) {
            return;
        }
        DetailAST resourcesDetailAST = resourceSpecificationDetailAST.findFirstToken(177);
        if (resourcesDetailAST == null) {
            return;
        }
        List closeableTypeNames = (List)closeableTypeNamesTuple.getObject(0);
        List<DetailAST> resourceDetailASTList = this.getAllChildTokens(resourcesDetailAST, false, 178);
        for (DetailAST resourceDetailAST : resourceDetailASTList) {
            String typeName;
            DetailAST typeDetailAST = resourceDetailAST.findFirstToken(13);
            if (typeDetailAST == null || (typeName = this._getFullyQualifiedTypeName(typeDetailAST, false)) == null || closeableTypeNames.contains(typeName)) continue;
            closeableTypeNames.add(typeName);
            Collections.sort(closeableTypeNames);
            try {
                FileUtil.write(closeableTypeNamesFile, ListUtil.toString(closeableTypeNames, "", ","));
                System.out.println(StringBundler.concat("Added '", typeName, "' to 'closeable-type-names.txt'"));
                this._closeableTypeNamesTuple = null;
            }
            catch (IOException iOException) {}
        }
    }

    private boolean _useTryWithResources(String variableName, DetailAST typeDetailAST, DetailAST literalTryDetailAST) {
        if (typeDetailAST == null) {
            return false;
        }
        DetailAST parentDetailAST = typeDetailAST.getParent();
        if (parentDetailAST.getType() != 10) {
            return false;
        }
        int lineNumber = literalTryDetailAST.getLineNo();
        int assignCount = 0;
        DetailAST assignDetailAST = parentDetailAST.findFirstToken(80);
        if (assignDetailAST != null) {
            DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
            if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 135) {
                ++assignCount;
            }
        }
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(parentDetailAST, variableName);
        for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
            DetailAST literalCatchDetailAST;
            DetailAST callerLiteralTryDetailAST;
            parentDetailAST = variableCallerDetailAST.getParent();
            if (parentDetailAST.getType() == 80) {
                if (assignCount > 0) {
                    return false;
                }
                DetailAST literalIfDetailAST = this.getParentWithTokenType(variableCallerDetailAST, 83);
                if (literalIfDetailAST != null && literalIfDetailAST.getLineNo() > typeDetailAST.getLineNo()) {
                    return false;
                }
                ++assignCount;
            }
            if (variableCallerDetailAST.getLineNo() > lineNumber || (callerLiteralTryDetailAST = this.getParentWithTokenType(variableCallerDetailAST, 95)) == null || callerLiteralTryDetailAST.getLineNo() > lineNumber || (literalCatchDetailAST = callerLiteralTryDetailAST.findFirstToken(96)) == null || callerLiteralTryDetailAST.getLineNo() >= lineNumber) continue;
            return false;
        }
        return true;
    }
}

