/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.staging.internal;

import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.staging.StagingURLHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.staging.StagingGroupHelper;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagingGroupHelper.class})
public class StagingGroupHelperImpl
implements StagingGroupHelper {
    private static final Log _log = LogFactoryUtil.getLog(StagingGroupHelperImpl.class);
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private StagingURLHelper _stagingURLHelper;

    public Group fetchLiveGroup(Group group) {
        if (this.isLocalStagingGroup(group)) {
            return this.fetchLocalLiveGroup(group);
        }
        if (this.isRemoteStagingGroup(group)) {
            return this.fetchRemoteLiveGroup(group);
        }
        return null;
    }

    public Group fetchLiveGroup(long groupId) {
        return this.fetchLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public Group fetchLocalLiveGroup(Group group) {
        if (!this.isLocalStagingGroup(group)) {
            return null;
        }
        group = this._getParentGroupForScopeGroup(group);
        return this._groupLocalService.fetchGroup(group.getLiveGroupId());
    }

    public Group fetchLocalLiveGroup(long groupId) {
        return this.fetchLocalLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public Group fetchLocalStagingGroup(Group group) {
        if (!this.isLocalLiveGroup(group)) {
            return null;
        }
        group = this._getParentGroupForScopeGroup(group);
        return this._groupLocalService.fetchStagingGroup(group.getGroupId());
    }

    public Group fetchLocalStagingGroup(long groupId) {
        return this.fetchLocalStagingGroup(this._groupLocalService.fetchGroup(groupId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group fetchRemoteLiveGroup(Group group) {
        if (!this.isRemoteStagingGroup(group)) {
            return null;
        }
        group = this._getParentGroupForScopeGroup(group);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            String remoteURL = this._stagingURLHelper.buildRemoteURL(group.getTypeSettingsProperties());
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            long remoteGroupId = GetterUtil.getLong((String)this._getTypeSettingsProperty(group, "remoteGroupId"));
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            Group group2 = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
            return group2;
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get remote live group: " + pe.getMessage()));
            }
            Group group3 = null;
            return group3;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public Group fetchRemoteLiveGroup(long groupId) {
        return this.fetchRemoteLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isLiveGroup(Group group) {
        return this.isLocalLiveGroup(group) || this.isRemoteLiveGroup(group);
    }

    public boolean isLiveGroup(long groupId) {
        return this.isLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isLocalLiveGroup(Group group) {
        if (group == null) {
            return false;
        }
        Group stagingGroup = this._groupLocalService.fetchStagingGroup((group = this._getParentGroupForScopeGroup(group)).getGroupId());
        return stagingGroup != null;
    }

    public boolean isLocalLiveGroup(long groupId) {
        return this.isLocalLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isLocalStagingGroup(Group group) {
        if (group == null) {
            return false;
        }
        return (group = this._getParentGroupForScopeGroup(group)).getLiveGroupId() != 0L;
    }

    public boolean isLocalStagingGroup(long groupId) {
        return this.isLocalStagingGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isLocalStagingOrLocalLiveGroup(Group group) {
        return this.isLocalStagingGroup(group) || this.isLocalLiveGroup(group);
    }

    public boolean isLocalStagingOrLocalLiveGroup(long groupId) {
        return this.isLocalStagingOrLocalLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isRemoteLiveGroup(Group group) {
        if (group == null) {
            return false;
        }
        return (group = this._getParentGroupForScopeGroup(group)).getRemoteStagingGroupCount() > 0;
    }

    public boolean isRemoteLiveGroup(long groupId) {
        return this.isRemoteLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isRemoteStagingGroup(Group group) {
        if (group == null) {
            return false;
        }
        group = this._getParentGroupForScopeGroup(group);
        return GetterUtil.getBoolean((String)this._getTypeSettingsProperty(group, "stagedRemotely"));
    }

    public boolean isRemoteStagingGroup(long groupId) {
        return this.isRemoteStagingGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isRemoteStagingOrRemoteLiveGroup(Group group) {
        return this.isRemoteStagingGroup(group) || this.isRemoteLiveGroup(group);
    }

    public boolean isRemoteStagingOrRemoteLiveGroup(long groupId) {
        return this.isRemoteStagingOrRemoteLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isStagedPortlet(Group group, String portletId) {
        if (!this.isStagingGroup(group) && !this.isLiveGroup(group)) {
            return false;
        }
        return group.isStagedPortlet(portletId);
    }

    public boolean isStagedPortlet(long groupId, String portletId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        return this.isStagedPortlet(group, portletId);
    }

    public boolean isStagedPortletData(long groupId, String className) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return true;
        }
        List dataSiteLevelPortlets = Collections.emptyList();
        try {
            dataSiteLevelPortlets = this._exportImportHelper.getDataSiteLevelPortlets(group.getCompanyId(), true);
        }
        catch (Exception e) {
            return true;
        }
        for (Portlet dataSiteLevelPortlet : dataSiteLevelPortlets) {
            PortletDataHandler portletDataHandler = dataSiteLevelPortlet.getPortletDataHandlerInstance();
            Object[] classNames = portletDataHandler.getClassNames();
            if (!ArrayUtil.contains((Object[])classNames, (Object)className)) continue;
            return this.isStagedPortlet(groupId, dataSiteLevelPortlet.getRootPortletId());
        }
        return true;
    }

    public boolean isStagingGroup(Group group) {
        return this.isLocalStagingGroup(group) || this.isRemoteStagingGroup(group);
    }

    public boolean isStagingGroup(long groupId) {
        return this.isStagingGroup(this._groupLocalService.fetchGroup(groupId));
    }

    public boolean isStagingOrLiveGroup(Group group) {
        return this.isStagingGroup(group) || this.isLiveGroup(group);
    }

    public boolean isStagingOrLiveGroup(long groupId) {
        return this.isStagingOrLiveGroup(this._groupLocalService.fetchGroup(groupId));
    }

    private Group _getParentGroupForScopeGroup(Group group) {
        if (group.isLayout()) {
            return group.getParentGroup();
        }
        return group;
    }

    private String _getTypeSettingsProperty(Group group, String key) {
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }
}

