/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.staging.internal.model.listener;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class GroupModelListener
extends BaseModelListener<Group> {
    private static final Log _log = LogFactoryUtil.getLog(GroupModelListener.class);
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;

    public void onBeforeRemove(Group group) throws ModelListenerException {
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(group.getGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        if (changesetCollection == null) {
            return;
        }
        try {
            this._changesetCollectionLocalService.deleteChangesetCollection(changesetCollection.getChangesetCollectionId());
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

