/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.staging.internal.model.listener;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.version.VersionedModel;
import com.liferay.staging.model.listener.StagingModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagingModelListener.class})
public class StagingModelListenerImpl<T extends BaseModel<T>>
implements StagingModelListener<T> {
    private static final Log _log = LogFactoryUtil.getLog(StagingModelListenerImpl.class);
    @Reference
    private Staging _staging;

    public void onAfterCreate(T model) throws ModelListenerException {
        if (!this._checkVersionedModel(model)) {
            return;
        }
        try {
            this._staging.addModelToChangesetCollection(model);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to add created model to the changeset", (Throwable)portalException);
        }
    }

    public void onAfterRemove(T model) throws ModelListenerException {
        if (!this._checkVersionedModel(model)) {
            return;
        }
        try {
            this._staging.removeModelFromChangesetCollection(model);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to remove model from the changeset", (Throwable)portalException);
        }
    }

    public void onAfterUpdate(T model) throws ModelListenerException {
        if (!this._checkVersionedModel(model)) {
            return;
        }
        try {
            this._staging.addModelToChangesetCollection(model);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to add updated model to the changeset", (Throwable)portalException);
        }
    }

    private boolean _checkVersionedModel(T model) {
        if (model == null) {
            return false;
        }
        boolean checkedModel = false;
        if (model instanceof VersionedModel) {
            VersionedModel versionedModel = (VersionedModel)model;
            if (versionedModel.isHead()) {
                checkedModel = true;
            }
        } else {
            checkedModel = true;
        }
        return checkedModel;
    }
}

