/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.internal.upgrade.v1_2_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.style.book.internal.upgrade.v1_2_0.util.StyleBookEntryVersionTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeStyleBookEntryVersion
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
    }

    protected void upgradeSchema() throws Exception {
        this.alter(StyleBookEntryVersionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "uuid_", "VARCHAR(75) null"), new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "modifiedDate", "DATE null")});
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select styleBookEntryId from StyleBookEntry");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update StyleBookEntryVersion set uuid_ = ? where styleBookEntryId = ?"));
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                ps2.setString(1, PortalUUIDUtil.generate());
                ps2.setLong(2, rs.getLong(1));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

