/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.service.impl;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.style.book.exception.DuplicateStyleBookEntryKeyException;
import com.liferay.style.book.exception.StyleBookEntryNameException;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.base.StyleBookEntryLocalServiceBaseImpl;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.style.book.model.StyleBookEntry"}, service={AopService.class})
public class StyleBookEntryLocalServiceImpl
extends StyleBookEntryLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public StyleBookEntry addStyleBookEntry(long userId, long groupId, String name, String styleBookEntryKey, ServiceContext serviceContext) throws PortalException {
        return this.addStyleBookEntry(userId, groupId, "", name, styleBookEntryKey, serviceContext);
    }

    public StyleBookEntry addStyleBookEntry(long userId, long groupId, String frontendTokensValues, String name, String styleBookEntryKey, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        if (serviceContext != null) {
            companyId = serviceContext.getCompanyId();
        } else {
            serviceContext = new ServiceContext();
        }
        this._validate(name);
        styleBookEntryKey = Validator.isNull((String)styleBookEntryKey) ? this.generateStyleBookEntryKey(groupId, name) : this._getStyleBookEntryKey(styleBookEntryKey);
        this._validateStyleBookEntryKey(groupId, styleBookEntryKey);
        StyleBookEntry styleBookEntry = this.create();
        String uuid = serviceContext.getUuid();
        if (Validator.isNotNull((String)uuid)) {
            styleBookEntry.setUuid(uuid);
        }
        styleBookEntry.setGroupId(groupId);
        styleBookEntry.setCompanyId(companyId);
        styleBookEntry.setUserId(user.getUserId());
        styleBookEntry.setUserName(user.getFullName());
        styleBookEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        styleBookEntry.setDefaultStyleBookEntry(false);
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        styleBookEntry.setName(name);
        styleBookEntry.setStyleBookEntryKey(styleBookEntryKey);
        return this.publishDraft(styleBookEntry);
    }

    public StyleBookEntry copyStyleBookEntry(long userId, long groupId, long styleBookEntryId, ServiceContext serviceContext) throws PortalException {
        StyleBookEntry styleBookEntry = this.getStyleBookEntry(styleBookEntryId);
        StringBundler sb = new StringBundler(5);
        sb.append(styleBookEntry.getName());
        sb.append(" ");
        sb.append("(");
        sb.append(LanguageUtil.get((Locale)LocaleUtil.getMostRelevantLocale(), (String)"copy"));
        sb.append(")");
        String name = sb.toString();
        StyleBookEntry copyStyleBookEntry = this.addStyleBookEntry(userId, groupId, styleBookEntry.getFrontendTokensValues(), name, "", serviceContext);
        long previewFileEntryId = this._copyStyleBookEntryPreviewFileEntry(userId, groupId, styleBookEntry, copyStyleBookEntry);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            StyleBookEntry copyDraftStyleBookEntry = this.getDraft(copyStyleBookEntry);
            copyDraftStyleBookEntry.setFrontendTokensValues(draftStyleBookEntry.getFrontendTokensValues());
            this.updateDraft(copyDraftStyleBookEntry);
        }
        return this.updatePreviewFileEntryId(copyStyleBookEntry.getStyleBookEntryId(), previewFileEntryId);
    }

    @Override
    public StyleBookEntry deleteStyleBookEntry(long styleBookEntryId) throws PortalException {
        return this.deleteStyleBookEntry(this.getStyleBookEntry(styleBookEntryId));
    }

    @Override
    public StyleBookEntry deleteStyleBookEntry(StyleBookEntry styleBookEntry) throws PortalException {
        if (styleBookEntry.getPreviewFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)styleBookEntry.getPreviewFileEntryId());
        }
        return this.delete(styleBookEntry);
    }

    public StyleBookEntry fetchDefaultStyleBookEntry(long groupId) {
        return this.styleBookEntryPersistence.fetchByG_D_Head_First(groupId, true, true, null);
    }

    public StyleBookEntry fetchStyleBookEntry(long groupId, String styleBookEntryKey) {
        return this.styleBookEntryPersistence.fetchByG_SBEK_First(groupId, this._getStyleBookEntryKey(styleBookEntryKey), null);
    }

    public StyleBookEntry fetchStyleBookEntryByUuidAndGroupId(String uuid, long groupId) {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.fetchByUUID_G_Head(uuid, groupId, true);
        if (styleBookEntry != null) {
            return styleBookEntry;
        }
        return this.styleBookEntryPersistence.fetchByUUID_G_Head(uuid, groupId, false);
    }

    public String generateStyleBookEntryKey(long groupId, String name) {
        String styleBookEntryKey = this._getStyleBookEntryKey(name);
        String curStyleBookEntryKey = styleBookEntryKey = StringUtil.replace((String)styleBookEntryKey, (char)' ', (char)'-');
        int count = 0;
        StyleBookEntry styleBookEntry;
        while ((styleBookEntry = this.fetchStyleBookEntry(groupId, curStyleBookEntryKey)) != null) {
            curStyleBookEntryKey = styleBookEntryKey + '-' + count++;
        }
        return curStyleBookEntryKey;
    }

    public List<StyleBookEntry> getStyleBookEntries(long groupId, int start, int end, OrderByComparator<StyleBookEntry> orderByComparator) {
        return this.styleBookEntryPersistence.findByGroupId_Head(groupId, true, start, end, orderByComparator);
    }

    public List<StyleBookEntry> getStyleBookEntries(long groupId, String name, int start, int end, OrderByComparator<StyleBookEntry> orderByComparator) {
        return this.styleBookEntryPersistence.findByG_LikeN_Head(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], true, start, end, orderByComparator);
    }

    public List<StyleBookEntry> getStyleBookEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.styleBookEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public int getStyleBookEntriesCount(long groupId) {
        return this.styleBookEntryPersistence.countByGroupId_Head(groupId, true);
    }

    public int getStyleBookEntriesCount(long groupId, String name) {
        return this.styleBookEntryPersistence.countByG_LikeN_Head(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], true);
    }

    public StyleBookEntry updateDefaultStyleBookEntry(long styleBookEntryId, boolean defaultStyleBookEntry) throws PortalException {
        StyleBookEntry styleBookEntry = this.fetchStyleBookEntry(styleBookEntryId);
        if (styleBookEntry == null) {
            return null;
        }
        StyleBookEntry oldDefaultStyleBookEntry = this.styleBookEntryPersistence.fetchByG_D_First(styleBookEntry.getGroupId(), true, null);
        if (defaultStyleBookEntry && oldDefaultStyleBookEntry != null && oldDefaultStyleBookEntry.getStyleBookEntryId() != styleBookEntryId) {
            oldDefaultStyleBookEntry.setDefaultStyleBookEntry(false);
            StyleBookEntry oldDefaultDraftStyleBookEntry = this.fetchDraft(oldDefaultStyleBookEntry);
            if (oldDefaultDraftStyleBookEntry != null) {
                oldDefaultDraftStyleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
                this.updateDraft(oldDefaultDraftStyleBookEntry);
            }
            this.styleBookEntryPersistence.update((BaseModel)oldDefaultStyleBookEntry);
        }
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateFrontendTokensValues(long styleBookEntryId, String frontendTokensValues) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setFrontendTokensValues(frontendTokensValues);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateName(long styleBookEntryId, String name) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._validate(name);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setName(name);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setName(name);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updatePreviewFileEntryId(long styleBookEntryId, long previewFileEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setPreviewFileEntryId(previewFileEntryId);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setPreviewFileEntryId(previewFileEntryId);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateStyleBookEntry(long userId, long styleBookEntryId, boolean defaultStylebookEntry, String frontendTokensValues, String name, String styleBookEntryKey, long previewFileEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._validate(name);
        styleBookEntryKey = Validator.isNull((String)styleBookEntryKey) ? this.generateStyleBookEntryKey(styleBookEntry.getGroupId(), name) : this._getStyleBookEntryKey(styleBookEntryKey);
        if (!StringUtil.equals((String)this._getStyleBookEntryKey(styleBookEntry.getStyleBookEntryKey()), (String)styleBookEntryKey)) {
            this._validateStyleBookEntryKey(styleBookEntry.getGroupId(), styleBookEntryKey);
        }
        styleBookEntry.setUserId(userId);
        styleBookEntry.setDefaultStyleBookEntry(defaultStylebookEntry);
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        styleBookEntry.setName(name);
        styleBookEntry.setPreviewFileEntryId(previewFileEntryId);
        styleBookEntry.setStyleBookEntryKey(styleBookEntryKey);
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateStyleBookEntry(long styleBookEntryId, String frontendTokensValues, String name) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._validate(name);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        styleBookEntry.setName(name);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setFrontendTokensValues(frontendTokensValues);
            draftStyleBookEntry.setName(name);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    private long _copyStyleBookEntryPreviewFileEntry(long userId, long groupId, StyleBookEntry styleBookEntry, StyleBookEntry copyStyleBookEntry) throws PortalException {
        if (styleBookEntry.getPreviewFileEntryId() == 0L) {
            return 0L;
        }
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(styleBookEntry.getPreviewFileEntryId());
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_style_book_web_internal_portlet_StyleBookPortlet");
        if (repository == null) {
            ServiceContext addPortletRepositoryServiceContext = new ServiceContext();
            addPortletRepositoryServiceContext.setAddGroupPermissions(true);
            addPortletRepositoryServiceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_style_book_web_internal_portlet_StyleBookPortlet", (ServiceContext)addPortletRepositoryServiceContext);
        }
        String fileName = copyStyleBookEntry.getStyleBookEntryId() + "_preview." + fileEntry.getExtension();
        fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)StyleBookEntry.class.getName(), (long)copyStyleBookEntry.getStyleBookEntryId(), (String)"com_liferay_style_book_web_internal_portlet_StyleBookPortlet", (long)repository.getDlFolderId(), (InputStream)fileEntry.getContentStream(), (String)fileName, (String)fileEntry.getMimeType(), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private String _getStyleBookEntryKey(String styleBookEntryKey) {
        if (styleBookEntryKey != null) {
            styleBookEntryKey = styleBookEntryKey.trim();
            return StringUtil.toLowerCase((String)styleBookEntryKey);
        }
        return "";
    }

    private void _validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new StyleBookEntryNameException("Name must not be null");
        }
        if (name.contains(".") || name.contains("/")) {
            throw new StyleBookEntryNameException("Name contains invalid characters");
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)StyleBookEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new StyleBookEntryNameException("Maximum length of name exceeded");
        }
    }

    private void _validateStyleBookEntryKey(long groupId, String styleBookEntryKey) throws PortalException {
        StyleBookEntry styleBookEntry = this.fetchStyleBookEntry(groupId, styleBookEntryKey = this._getStyleBookEntryKey(styleBookEntryKey));
        if (styleBookEntry != null) {
            throw new DuplicateStyleBookEntryKeyException();
        }
    }
}

