/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.text.localizer.taglib.internal.address.util;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.text.localizer.address.AddressTextLocalizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class AddressTextLocalizerUtil {
    private static final ServiceTrackerMap<String, AddressTextLocalizer> _serviceTrackerMap;

    public static String format(Address address) {
        AddressTextLocalizer addressTextLocalizer = AddressTextLocalizerUtil.getAddressTextLocalizer(address);
        return addressTextLocalizer.format(address);
    }

    public static AddressTextLocalizer getAddressTextLocalizer(Address address) {
        AddressTextLocalizer addressTextLocalizer = null;
        Country country = address.getCountry();
        if (country != null) {
            addressTextLocalizer = AddressTextLocalizerUtil.getAddressTextLocalizer(country.getA2());
        }
        if (addressTextLocalizer == null) {
            addressTextLocalizer = AddressTextLocalizerUtil.getAddressTextLocalizer("US");
        }
        return addressTextLocalizer;
    }

    public static AddressTextLocalizer getAddressTextLocalizer(String countryA2) {
        return (AddressTextLocalizer)_serviceTrackerMap.getService((Object)countryA2);
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(AddressTextLocalizerUtil.class);
        BundleContext bundleContext = bundle.getBundleContext();
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, AddressTextLocalizer.class, (String)"country");
    }
}

