/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordPolicyRel;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrgLaborLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyRelLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class OrganizationStagedModelDataHandler
extends BaseStagedModelDataHandler<Organization> {
    public static final String[] CLASS_NAMES = new String[]{Organization.class.getName()};
    private AddressLocalService _addressLocalService;
    private EmailAddressLocalService _emailAddressLocalService;
    private GroupLocalService _groupLocalService;
    private OrganizationLocalService _organizationLocalService;
    private OrgLaborLocalService _orgLaborLocalService;
    private PasswordPolicyLocalService _passwordPolicyLocalService;
    private PasswordPolicyRelLocalService _passwordPolicyRelLocalService;
    private PhoneLocalService _phoneLocalService;
    private WebsiteLocalService _websiteLocalService;

    public void deleteStagedModel(Organization organization) throws PortalException {
        this._organizationLocalService.deleteOrganization(organization);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Organization organization = this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(uuid, group.getCompanyId());
        if (organization != null) {
            this.deleteStagedModel(organization);
        }
    }

    public List<Organization> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        organizations.add(this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(uuid, companyId));
        return organizations;
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Organization organization) {
        return organization.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        LinkedList<Organization> organizations = new LinkedList<Organization>();
        organizations.add(organization);
        while (!organizations.isEmpty()) {
            Organization exportedOrganization = (Organization)organizations.remove();
            if (exportedOrganization.getParentOrganizationId() != 0L) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)exportedOrganization, (StagedModel)exportedOrganization.getParentOrganization(), (String)"parent");
            }
            this.exportAddresses(portletDataContext, exportedOrganization);
            this.exportEmailAddresses(portletDataContext, exportedOrganization);
            this.exportOrgLabors(portletDataContext, exportedOrganization);
            this.exportPasswordPolicyRel(portletDataContext, exportedOrganization);
            this.exportPhones(portletDataContext, exportedOrganization);
            this.exportWebsites(portletDataContext, exportedOrganization);
            Element organizationElement = portletDataContext.getExportDataElement((ClassedModel)exportedOrganization);
            portletDataContext.addClassedModel(organizationElement, ExportImportPathUtil.getModelPath((StagedModel)exportedOrganization), (ClassedModel)exportedOrganization);
            organizations.addAll(exportedOrganization.getSuborganizations());
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        long userId = portletDataContext.getUserId(organization.getUserUuid());
        Map organizationIds = portletDataContext.getNewPrimaryKeysMap(Organization.class);
        long parentOrganizationId = MapUtil.getLong((Map)organizationIds, (long)organization.getParentOrganizationId(), (long)organization.getParentOrganizationId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)organization);
        serviceContext.setUserId(userId);
        Organization existingOrganization = this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(organization.getUuid(), portletDataContext.getGroupId());
        if (existingOrganization == null) {
            existingOrganization = this._organizationLocalService.fetchOrganization(portletDataContext.getCompanyId(), organization.getName());
        }
        Organization importedOrganization = null;
        if (existingOrganization == null) {
            serviceContext.setUuid(organization.getUuid());
            importedOrganization = this._organizationLocalService.addOrganization(userId, parentOrganizationId, organization.getName(), organization.getType(), organization.getRegionId(), organization.getCountryId(), organization.getStatusId(), organization.getComments(), false, serviceContext);
        } else {
            importedOrganization = this._organizationLocalService.updateOrganization(portletDataContext.getCompanyId(), existingOrganization.getOrganizationId(), parentOrganizationId, organization.getName(), organization.getType(), organization.getRegionId(), organization.getCountryId(), organization.getStatusId(), organization.getComments(), true, null, false, serviceContext);
        }
        this.importAddresses(portletDataContext, organization, importedOrganization);
        this.importEmailAddresses(portletDataContext, organization, importedOrganization);
        this.importOrgLabors(portletDataContext, organization, importedOrganization);
        this.importPasswordPolicyRel(portletDataContext, organization, importedOrganization);
        this.importPhones(portletDataContext, organization, importedOrganization);
        this.importWebsites(portletDataContext, organization, importedOrganization);
        portletDataContext.importClassedModel((ClassedModel)organization, (ClassedModel)importedOrganization);
    }

    protected void exportAddresses(PortletDataContext portletDataContext, Organization organization) throws PortalException {
        List addresses = this._addressLocalService.getAddresses(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (Address address : addresses) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)address, (String)"embedded");
        }
    }

    protected void exportEmailAddresses(PortletDataContext portletDataContext, Organization organization) throws PortalException {
        List emailAddresses = this._emailAddressLocalService.getEmailAddresses(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (EmailAddress emailAddress : emailAddresses) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)emailAddress, (String)"embedded");
        }
    }

    protected void exportOrgLabors(PortletDataContext portletDataContext, Organization organization) {
        List orgLabors = this._orgLaborLocalService.getOrgLabors(organization.getOrganizationId());
        String path = ExportImportPathUtil.getModelPath((StagedModel)organization, (String)OrgLabor.class.getSimpleName());
        portletDataContext.addZipEntry(path, (Object)orgLabors);
    }

    protected void exportPasswordPolicyRel(PortletDataContext portletDataContext, Organization organization) throws PortalException {
        PasswordPolicyRel passwordPolicyRel = this._passwordPolicyRelLocalService.fetchPasswordPolicyRel(Organization.class.getName(), organization.getOrganizationId());
        if (passwordPolicyRel == null) {
            return;
        }
        PasswordPolicy passwordPolicy = this._passwordPolicyLocalService.getPasswordPolicy(passwordPolicyRel.getPasswordPolicyId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)passwordPolicy, (String)"strong");
    }

    protected void exportPhones(PortletDataContext portletDataContext, Organization organization) throws PortalException {
        List phones = this._phoneLocalService.getPhones(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (Phone phone : phones) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)phone, (String)"embedded");
        }
    }

    protected void exportWebsites(PortletDataContext portletDataContext, Organization organization) throws PortalException {
        List websites = this._websiteLocalService.getWebsites(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (Website website : websites) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)website, (String)"embedded");
        }
    }

    protected void importAddresses(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException {
        List addressElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Address.class);
        ArrayList<Address> addresses = new ArrayList<Address>(addressElements.size());
        for (Element addressElement : addressElements) {
            String addressPath = addressElement.attributeValue("path");
            Address address = (Address)portletDataContext.getZipEntryAsObject(addressElement, addressPath);
            address.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)address);
            Map addressIds = portletDataContext.getNewPrimaryKeysMap(Address.class);
            long addressId = (Long)addressIds.get(address.getPrimaryKey());
            address.setAddressId(addressId);
            addresses.add(address);
        }
        UsersAdminUtil.updateAddresses((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), addresses);
    }

    protected void importEmailAddresses(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException {
        List emailAddressElements = portletDataContext.getReferenceDataElements((StagedModel)organization, EmailAddress.class);
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>(emailAddressElements.size());
        for (Element emailAddressElement : emailAddressElements) {
            String emailAddressPath = emailAddressElement.attributeValue("path");
            EmailAddress emailAddress = (EmailAddress)portletDataContext.getZipEntryAsObject(emailAddressElement, emailAddressPath);
            emailAddress.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)emailAddress);
            Map emailAddressIds = portletDataContext.getNewPrimaryKeysMap(EmailAddress.class);
            long emailAddressId = (Long)emailAddressIds.get(emailAddress.getPrimaryKey());
            emailAddress.setEmailAddressId(emailAddressId);
            emailAddresses.add(emailAddress);
        }
        UsersAdminUtil.updateEmailAddresses((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), emailAddresses);
    }

    protected void importOrgLabors(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException {
        String path = ExportImportPathUtil.getModelPath((StagedModel)organization, (String)OrgLabor.class.getSimpleName());
        List orgLabors = (List)portletDataContext.getZipEntryAsObject(path);
        for (OrgLabor orgLabor : orgLabors) {
            orgLabor.setOrgLaborId(0L);
        }
        UsersAdminUtil.updateOrgLabors((long)importedOrganization.getOrganizationId(), (List)orgLabors);
    }

    protected void importPasswordPolicyRel(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException {
        List passwordPolicyElements = portletDataContext.getReferenceDataElements((StagedModel)organization, PasswordPolicy.class);
        if (passwordPolicyElements.isEmpty()) {
            return;
        }
        Element passwordPolicyElement = (Element)passwordPolicyElements.get(0);
        String passwordPolicyPath = passwordPolicyElement.attributeValue("path");
        PasswordPolicy passwordPolicy = (PasswordPolicy)portletDataContext.getZipEntryAsObject(passwordPolicyPath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)passwordPolicy);
        Map passwordPolicyIds = portletDataContext.getNewPrimaryKeysMap(PasswordPolicy.class);
        long passwordPolicyId = (Long)passwordPolicyIds.get(passwordPolicy.getPrimaryKey());
        this._organizationLocalService.addPasswordPolicyOrganizations(passwordPolicyId, new long[]{importedOrganization.getOrganizationId()});
    }

    protected void importPhones(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException {
        List phoneElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Phone.class);
        ArrayList<Phone> phones = new ArrayList<Phone>(phoneElements.size());
        for (Element phoneElement : phoneElements) {
            String phonePath = phoneElement.attributeValue("path");
            Phone phone = (Phone)portletDataContext.getZipEntryAsObject(phoneElement, phonePath);
            phone.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)phone);
            Map phoneIds = portletDataContext.getNewPrimaryKeysMap(Phone.class);
            long phoneId = (Long)phoneIds.get(phone.getPrimaryKey());
            phone.setPhoneId(phoneId);
            phones.add(phone);
        }
        UsersAdminUtil.updatePhones((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), phones);
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, Organization organization) throws PortletDataException {
        if (organization.getParentOrganizationId() != 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, Organization.class, (long)organization.getParentOrganizationId());
        }
    }

    protected void importWebsites(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException {
        List websiteElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Website.class);
        ArrayList<Website> websites = new ArrayList<Website>(websiteElements.size());
        for (Element websiteElement : websiteElements) {
            String websitePath = websiteElement.attributeValue("path");
            Website website = (Website)portletDataContext.getZipEntryAsObject(websiteElement, websitePath);
            website.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)website);
            Map websiteIds = portletDataContext.getNewPrimaryKeysMap(Website.class);
            long websiteId = (Long)websiteIds.get(website.getPrimaryKey());
            website.setWebsiteId(websiteId);
            websites.add(website);
        }
        UsersAdminUtil.updateWebsites((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), websites);
    }

    @Reference(unbind="-")
    protected void setAddressLocalService(AddressLocalService addressLocalService) {
        this._addressLocalService = addressLocalService;
    }

    @Reference(unbind="-")
    protected void setEmailAddressLocalService(EmailAddressLocalService emailAddressLocalService) {
        this._emailAddressLocalService = emailAddressLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setOrganizationLocalService(OrganizationLocalService organizationLocalService) {
        this._organizationLocalService = organizationLocalService;
    }

    @Reference(unbind="-")
    protected void setOrgLaborLocalService(OrgLaborLocalService orgLaborLocalService) {
        this._orgLaborLocalService = orgLaborLocalService;
    }

    @Reference(unbind="-")
    protected void setPasswordPolicyLocalService(PasswordPolicyLocalService passwordPolicyLocalService) {
        this._passwordPolicyLocalService = passwordPolicyLocalService;
    }

    @Reference(unbind="-")
    protected void setPasswordPolicyRelLocalService(PasswordPolicyRelLocalService passwordPolicyRelLocalService) {
        this._passwordPolicyRelLocalService = passwordPolicyRelLocalService;
    }

    @Reference(unbind="-")
    protected void setPhoneLocalService(PhoneLocalService phoneLocalService) {
        this._phoneLocalService = phoneLocalService;
    }

    @Reference(unbind="-")
    protected void setWebsiteLocalService(WebsiteLocalService websiteLocalService) {
        this._websiteLocalService = websiteLocalService;
    }
}

