/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.util.PortalInstances;
import org.osgi.service.component.annotations.Component;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    public void onBeforeRemove(User user) throws ModelListenerException {
        if (PortalInstances.isCurrentCompanyInDeletionProcess()) {
            return;
        }
        if (user.getType() == 2) {
            throw new ModelListenerException((Throwable)new RequiredUserException("Default service account cannot be removed"));
        }
    }

    public void onBeforeUpdate(User originalUser, User user) throws ModelListenerException {
        if (originalUser.getType() != user.getType()) {
            throw new ModelListenerException("User's type cannot be changed");
        }
        if (originalUser.getType() == 2 && originalUser.getScreenName() != user.getScreenName()) {
            throw new ModelListenerException((Throwable)new RequiredUserException("Screen name for default service account cannot be changed"));
        }
    }
}

