/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.theme.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=THEME"}, service={TemplateContextContributor.class})
public class UsersTemplateContextContributor
implements TemplateContextContributor {
    private static final Log _log = LogFactoryUtil.getLog(UsersTemplateContextContributor.class);
    private UserLocalService _userLocalService;

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        contextObjects.put("is_default_user", user.isDefaultUser());
        try {
            contextObjects.put("is_female", user.isFemale());
            contextObjects.put("is_male", user.isMale());
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        contextObjects.put("is_setup_complete", user.isSetupComplete());
        contextObjects.put("language", themeDisplay.getLanguageId());
        contextObjects.put("language_id", user.getLanguageId());
        try {
            contextObjects.put("user_birthday", user.getBirthday());
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        contextObjects.put("user_comments", user.getComments());
        contextObjects.put("user_email_address", user.getEmailAddress());
        contextObjects.put("user_first_name", user.getFirstName());
        contextObjects.put("user_greeting", HtmlUtil.escape((String)user.getGreeting()));
        contextObjects.put("user_id", user.getUserId());
        contextObjects.put("user_last_login_ip", user.getLastLoginIP());
        contextObjects.put("user_last_name", user.getLastName());
        contextObjects.put("user_login_ip", user.getLoginIP());
        contextObjects.put("user_middle_name", user.getMiddleName());
        contextObjects.put("user_name", user.getFullName());
        Group group = themeDisplay.getSiteGroup();
        if (group.isUser()) {
            try {
                User user2 = this._userLocalService.getUserById(group.getClassPK());
                contextObjects.put("user2", user2);
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        contextObjects.put("w3c_language_id", LocaleUtil.toW3cLanguageId((String)themeDisplay.getLanguageId()));
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

