/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.portlet.action;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/export_users"}, service={MVCResourceCommand.class})
public class ExportUsersMVCResourceCommand
extends BaseMVCResourceCommand {
    private static final Log _log = LogFactoryUtil.getLog(ExportUsersMVCResourceCommand.class);
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            SessionMessages.add((PortletRequest)resourceRequest, (String)(this._portal.getPortletId((PortletRequest)resourceRequest) + ".hideDefaultErrorMessage"));
            String csv = this.getUsersCSV(resourceRequest, resourceResponse);
            PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)"users.csv", (byte[])csv.getBytes(), (String)"text/csv; charset=UTF-8");
        }
        catch (Exception e) {
            SessionErrors.add((PortletRequest)resourceRequest, e.getClass());
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected String getUserCSV(User user) {
        StringBundler sb = new StringBundler(PropsValues.USERS_EXPORT_CSV_FIELDS.length * 2);
        for (int i = 0; i < PropsValues.USERS_EXPORT_CSV_FIELDS.length; ++i) {
            String field = PropsValues.USERS_EXPORT_CSV_FIELDS[i];
            if (field.startsWith("expando:")) {
                String attributeName = field.substring(8);
                ExpandoBridge expandoBridge = user.getExpandoBridge();
                sb.append(CSVUtil.encode((Object)expandoBridge.getAttribute(attributeName)));
            } else if (field.contains("Date")) {
                Date date = (Date)BeanPropertiesUtil.getObject((Object)user, (String)field);
                if (date instanceof Timestamp) {
                    date = new Date(date.getTime());
                }
                sb.append(CSVUtil.encode((String)String.valueOf(date)));
            } else if (field.equals("fullName")) {
                sb.append(CSVUtil.encode((String)user.getFullName()));
            } else {
                sb.append(CSVUtil.encode((String)BeanPropertiesUtil.getString((Object)user, (String)field)));
            }
            if (i + 1 >= PropsValues.USERS_EXPORT_CSV_FIELDS.length) continue;
            sb.append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    protected List<User> getUsers(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        Indexer indexer;
        long userGroupId;
        User user;
        Long[] organizationIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        boolean exportAllUsers = PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"EXPORT_USER");
        if (!exportAllUsers && !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"com_liferay_users_admin_web_portlet_UsersAdminPortlet", (String)"EXPORT_USER")) {
            return Collections.emptyList();
        }
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)resourceResponse);
        LiferayPortletURL portletURL = liferayPortletResponse.createRenderURL("com_liferay_users_admin_web_portlet_UsersAdminPortlet");
        UserSearch userSearch = new UserSearch((PortletRequest)resourceRequest, (PortletURL)portletURL);
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        long organizationId = searchTerms.getOrganizationId();
        if (organizationId > 0L) {
            params.put("usersOrgs", organizationId);
        } else if (!exportAllUsers && (organizationIds = ArrayUtil.toArray((long[])(user = themeDisplay.getUser()).getOrganizationIds(true))).length > 0) {
            params.put("usersOrgs", organizationIds);
        }
        long roleId = searchTerms.getRoleId();
        if (roleId > 0L) {
            params.put("usersRoles", roleId);
        }
        if ((userGroupId = searchTerms.getUserGroupId()) > 0L) {
            params.put("usersUserGroups", userGroupId);
        }
        if ((indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class)).isIndexerEnabled() && PropsValues.USERS_SEARCH_WITH_INDEX) {
            params.put("expandoAttributes", searchTerms.getKeywords());
        }
        if (searchTerms.isAdvancedSearch()) {
            return this._userLocalService.search(themeDisplay.getCompanyId(), searchTerms.getFirstName(), searchTerms.getMiddleName(), searchTerms.getLastName(), searchTerms.getScreenName(), searchTerms.getEmailAddress(), searchTerms.getStatus(), params, searchTerms.isAndOperator(), -1, -1, (OrderByComparator)null);
        }
        return this._userLocalService.search(themeDisplay.getCompanyId(), searchTerms.getKeywords(), searchTerms.getStatus(), params, -1, -1, (OrderByComparator)null);
    }

    protected String getUsersCSV(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        List<User> users = this.getUsers(resourceRequest, resourceResponse);
        if (users.isEmpty()) {
            return "";
        }
        String exportProgressId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"exportProgressId");
        ProgressTracker progressTracker = new ProgressTracker(exportProgressId);
        progressTracker.start((PortletRequest)resourceRequest);
        int percentage = 10;
        int total = users.size();
        progressTracker.setPercent(percentage);
        StringBundler sb = new StringBundler(users.size());
        for (int i = 0; i < users.size(); ++i) {
            User user = users.get(i);
            sb.append(this.getUserCSV(user));
            percentage = Math.min(10 + i * 90 / total, 99);
            progressTracker.setPercent(percentage);
        }
        progressTracker.finish((PortletRequest)resourceRequest);
        return sb.toString();
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

