/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.portlet.action;

import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/get_users_count"}, service={MVCResourceCommand.class})
public class GetUsersCountMVCResourceCommand
implements MVCResourceCommand {
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public boolean serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            PrintWriter printWriter = resourceResponse.getWriter();
            printWriter.write(this.getText(resourceRequest, resourceResponse));
            return true;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected int getOrganizationUsersCount(long companyId, long[] organizationIds, int status) throws Exception {
        int count = 0;
        for (long organizationId : organizationIds) {
            LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
            params.put("usersOrgs", organizationId);
            count += this._userLocalService.searchCount(companyId, null, status, params);
        }
        return count;
    }

    protected String getText(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        HttpServletRequest request = this._portal.getOriginalServletRequest(this._portal.getHttpServletRequest((PortletRequest)resourceRequest));
        long companyId = this._portal.getCompanyId(request);
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"className");
        long[] ids = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"ids"), (long)0L);
        int status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status");
        int count = 0;
        if (className.equals(Organization.class.getName())) {
            count = this.getOrganizationUsersCount(companyId, ids, status);
        } else if (className.equals(UserGroup.class.getName())) {
            count = this.getUserGroupUsersCount(companyId, ids, status);
        }
        return String.valueOf(count);
    }

    protected int getUserGroupUsersCount(long companyId, long[] userGroupIds, int status) throws Exception {
        int count = 0;
        for (long userGroupId : userGroupIds) {
            LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
            params.put("usersUserGroups", userGroupId);
            count += this._userLocalService.searchCount(companyId, null, status, params);
        }
        return count;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

