/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.layout.prototype.internal.instance.lifecycle;

import com.liferay.layout.page.template.util.LayoutPrototypeHelperUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.DefaultLayoutPrototypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.wiki.model.WikiPage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddLayoutPrototypePortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        long defaultUserId = this._userLocalService.getDefaultUserId(company.getCompanyId());
        List layoutPrototypes = this._layoutPrototypeLocalService.search(company.getCompanyId(), null, -1, -1, null);
        this.addWikiPage(company.getCompanyId(), defaultUserId, layoutPrototypes);
    }

    protected void addWikiPage(long companyId, long defaultUserId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        Map descriptionMap;
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleUtil.getResourceBundleLoader((String)"content.Language", (ClassLoader)this.getClassLoader()), LanguageResources.RESOURCE_BUNDLE_LOADER});
        Map nameMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, (String)"layout-prototype-wiki-title");
        Layout layout = LayoutPrototypeHelperUtil.addLayoutPrototype((LayoutPrototypeLocalService)this._layoutPrototypeLocalService, (long)companyId, (long)defaultUserId, (Map)nameMap, (Map)(descriptionMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, (String)"layout-prototype-wiki-description")), (String)"2_columns_iii", layoutPrototypes);
        if (layout == null) {
            return;
        }
        DefaultLayoutPrototypesUtil.addPortletId((Layout)layout, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (String)"column-1");
        DefaultLayoutPrototypesUtil.addPortletId((Layout)layout, (String)"com_liferay_asset_categories_navigation_web_portlet_AssetCategoriesNavigationPortlet", (String)"column-2");
        String portletId = DefaultLayoutPrototypesUtil.addPortletId((Layout)layout, (String)"com_liferay_asset_tags_navigation_web_portlet_AssetTagsNavigationPortlet", (String)"column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("classNameId", String.valueOf(this._portal.getClassNameId(WikiPage.class)));
        preferences.put("showAssetCount", Boolean.TRUE.toString());
        DefaultLayoutPrototypesUtil.updatePortletSetup((Layout)layout, (String)portletId, preferences);
    }

    @Reference(target="(javax.portlet.name=com_liferay_asset_categories_navigation_web_portlet_AssetCategoriesNavigationPortlet)", unbind="-")
    protected void setAssetCategoriesNavigationPortlet(Portlet portlet) {
    }

    @Reference(target="(javax.portlet.name=com_liferay_asset_tags_navigation_web_portlet_AssetTagsNavigationPortlet)", unbind="-")
    protected void setAssetTagsNavigationPortlet(Portlet portlet) {
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeLocalService(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    @Reference(target="(javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet)", unbind="-")
    protected void setWikiPortlet(Portlet portlet) {
    }
}

