/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wiki.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageModel;
import com.liferay.wiki.model.WikiPageSoap;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the WikiPage service. Represents a row in the &quot;WikiPage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>WikiPageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WikiPageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WikiPageImpl
 * @generated
 */
@JSON(strict = true)
public class WikiPageModelImpl
	extends BaseModelImpl<WikiPage> implements WikiPageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a wiki page model instance should use the <code>WikiPage</code> interface instead.
	 */
	public static final String TABLE_NAME = "WikiPage";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"pageId", Types.BIGINT},
		{"resourcePrimKey", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"nodeId", Types.BIGINT},
		{"title", Types.VARCHAR}, {"version", Types.DOUBLE},
		{"minorEdit", Types.BOOLEAN}, {"content", Types.CLOB},
		{"summary", Types.VARCHAR}, {"format", Types.VARCHAR},
		{"head", Types.BOOLEAN}, {"parentTitle", Types.VARCHAR},
		{"redirectTitle", Types.VARCHAR}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("resourcePrimKey", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("nodeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("minorEdit", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("content", Types.CLOB);
		TABLE_COLUMNS_MAP.put("summary", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("format", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("head", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("parentTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("redirectTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table WikiPage (uuid_ VARCHAR(75) null,pageId LONG not null primary key,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,nodeId LONG,title VARCHAR(255) null,version DOUBLE,minorEdit BOOLEAN,content TEXT null,summary STRING null,format VARCHAR(75) null,head BOOLEAN,parentTitle VARCHAR(255) null,redirectTitle VARCHAR(255) null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table WikiPage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY wikiPage.nodeId ASC, wikiPage.title ASC, wikiPage.version DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY WikiPage.nodeId ASC, WikiPage.title ASC, WikiPage.version DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.wiki.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.wiki.model.WikiPage"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.wiki.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.wiki.model.WikiPage"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.wiki.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.wiki.model.WikiPage"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long FORMAT_COLUMN_BITMASK = 2L;

	public static final long GROUPID_COLUMN_BITMASK = 4L;

	public static final long HEAD_COLUMN_BITMASK = 8L;

	public static final long NODEID_COLUMN_BITMASK = 16L;

	public static final long PARENTTITLE_COLUMN_BITMASK = 32L;

	public static final long REDIRECTTITLE_COLUMN_BITMASK = 64L;

	public static final long RESOURCEPRIMKEY_COLUMN_BITMASK = 128L;

	public static final long STATUS_COLUMN_BITMASK = 256L;

	public static final long TITLE_COLUMN_BITMASK = 512L;

	public static final long USERID_COLUMN_BITMASK = 1024L;

	public static final long UUID_COLUMN_BITMASK = 2048L;

	public static final long VERSION_COLUMN_BITMASK = 4096L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static WikiPage toModel(WikiPageSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		WikiPage model = new WikiPageImpl();

		model.setUuid(soapModel.getUuid());
		model.setPageId(soapModel.getPageId());
		model.setResourcePrimKey(soapModel.getResourcePrimKey());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setNodeId(soapModel.getNodeId());
		model.setTitle(soapModel.getTitle());
		model.setVersion(soapModel.getVersion());
		model.setMinorEdit(soapModel.isMinorEdit());
		model.setContent(soapModel.getContent());
		model.setSummary(soapModel.getSummary());
		model.setFormat(soapModel.getFormat());
		model.setHead(soapModel.isHead());
		model.setParentTitle(soapModel.getParentTitle());
		model.setRedirectTitle(soapModel.getRedirectTitle());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<WikiPage> toModels(WikiPageSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<WikiPage> models = new ArrayList<WikiPage>(soapModels.length);

		for (WikiPageSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.wiki.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.wiki.model.WikiPage"));

	public WikiPageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _pageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setPageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _pageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return WikiPage.class;
	}

	@Override
	public String getModelClassName() {
		return WikiPage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<WikiPage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WikiPage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((WikiPage)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<WikiPage, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<WikiPage, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(WikiPage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<WikiPage, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<WikiPage, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, WikiPage>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			WikiPage.class.getClassLoader(), WikiPage.class,
			ModelWrapper.class);

		try {
			Constructor<WikiPage> constructor =
				(Constructor<WikiPage>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<WikiPage, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<WikiPage, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<WikiPage, Object>>();
		Map<String, BiConsumer<WikiPage, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<WikiPage, ?>>();

		attributeGetterFunctions.put(
			"uuid",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getUuid();
				}

			});
		attributeSetterBiConsumers.put(
			"uuid",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object uuidObject) {
					wikiPage.setUuid((String)uuidObject);
				}

			});
		attributeGetterFunctions.put(
			"pageId",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getPageId();
				}

			});
		attributeSetterBiConsumers.put(
			"pageId",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object pageIdObject) {
					wikiPage.setPageId((Long)pageIdObject);
				}

			});
		attributeGetterFunctions.put(
			"resourcePrimKey",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getResourcePrimKey();
				}

			});
		attributeSetterBiConsumers.put(
			"resourcePrimKey",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object resourcePrimKeyObject) {

					wikiPage.setResourcePrimKey((Long)resourcePrimKeyObject);
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getGroupId();
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object groupIdObject) {
					wikiPage.setGroupId((Long)groupIdObject);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object companyIdObject) {
					wikiPage.setCompanyId((Long)companyIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object userIdObject) {
					wikiPage.setUserId((Long)userIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object userNameObject) {
					wikiPage.setUserName((String)userNameObject);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object createDateObject) {
					wikiPage.setCreateDate((Date)createDateObject);
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getModifiedDate();
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object modifiedDateObject) {

					wikiPage.setModifiedDate((Date)modifiedDateObject);
				}

			});
		attributeGetterFunctions.put(
			"nodeId",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getNodeId();
				}

			});
		attributeSetterBiConsumers.put(
			"nodeId",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object nodeIdObject) {
					wikiPage.setNodeId((Long)nodeIdObject);
				}

			});
		attributeGetterFunctions.put(
			"title",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getTitle();
				}

			});
		attributeSetterBiConsumers.put(
			"title",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object titleObject) {
					wikiPage.setTitle((String)titleObject);
				}

			});
		attributeGetterFunctions.put(
			"version",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getVersion();
				}

			});
		attributeSetterBiConsumers.put(
			"version",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object versionObject) {
					wikiPage.setVersion((Double)versionObject);
				}

			});
		attributeGetterFunctions.put(
			"minorEdit",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getMinorEdit();
				}

			});
		attributeSetterBiConsumers.put(
			"minorEdit",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object minorEditObject) {
					wikiPage.setMinorEdit((Boolean)minorEditObject);
				}

			});
		attributeGetterFunctions.put(
			"content",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getContent();
				}

			});
		attributeSetterBiConsumers.put(
			"content",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object contentObject) {
					wikiPage.setContent((String)contentObject);
				}

			});
		attributeGetterFunctions.put(
			"summary",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getSummary();
				}

			});
		attributeSetterBiConsumers.put(
			"summary",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object summaryObject) {
					wikiPage.setSummary((String)summaryObject);
				}

			});
		attributeGetterFunctions.put(
			"format",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getFormat();
				}

			});
		attributeSetterBiConsumers.put(
			"format",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object formatObject) {
					wikiPage.setFormat((String)formatObject);
				}

			});
		attributeGetterFunctions.put(
			"head",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getHead();
				}

			});
		attributeSetterBiConsumers.put(
			"head",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object headObject) {
					wikiPage.setHead((Boolean)headObject);
				}

			});
		attributeGetterFunctions.put(
			"parentTitle",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getParentTitle();
				}

			});
		attributeSetterBiConsumers.put(
			"parentTitle",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object parentTitleObject) {

					wikiPage.setParentTitle((String)parentTitleObject);
				}

			});
		attributeGetterFunctions.put(
			"redirectTitle",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getRedirectTitle();
				}

			});
		attributeSetterBiConsumers.put(
			"redirectTitle",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object redirectTitleObject) {

					wikiPage.setRedirectTitle((String)redirectTitleObject);
				}

			});
		attributeGetterFunctions.put(
			"lastPublishDate",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getLastPublishDate();
				}

			});
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object lastPublishDateObject) {

					wikiPage.setLastPublishDate((Date)lastPublishDateObject);
				}

			});
		attributeGetterFunctions.put(
			"status",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getStatus();
				}

			});
		attributeSetterBiConsumers.put(
			"status",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object statusObject) {
					wikiPage.setStatus((Integer)statusObject);
				}

			});
		attributeGetterFunctions.put(
			"statusByUserId",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getStatusByUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"statusByUserId",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object statusByUserIdObject) {

					wikiPage.setStatusByUserId((Long)statusByUserIdObject);
				}

			});
		attributeGetterFunctions.put(
			"statusByUserName",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getStatusByUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"statusByUserName",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(
					WikiPage wikiPage, Object statusByUserNameObject) {

					wikiPage.setStatusByUserName(
						(String)statusByUserNameObject);
				}

			});
		attributeGetterFunctions.put(
			"statusDate",
			new Function<WikiPage, Object>() {

				@Override
				public Object apply(WikiPage wikiPage) {
					return wikiPage.getStatusDate();
				}

			});
		attributeSetterBiConsumers.put(
			"statusDate",
			new BiConsumer<WikiPage, Object>() {

				@Override
				public void accept(WikiPage wikiPage, Object statusDateObject) {
					wikiPage.setStatusDate((Date)statusDateObject);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getPageId() {
		return _pageId;
	}

	@Override
	public void setPageId(long pageId) {
		_pageId = pageId;
	}

	@JSON
	@Override
	public long getResourcePrimKey() {
		return _resourcePrimKey;
	}

	@Override
	public void setResourcePrimKey(long resourcePrimKey) {
		_columnBitmask |= RESOURCEPRIMKEY_COLUMN_BITMASK;

		if (!_setOriginalResourcePrimKey) {
			_setOriginalResourcePrimKey = true;

			_originalResourcePrimKey = _resourcePrimKey;
		}

		_resourcePrimKey = resourcePrimKey;
	}

	@Override
	public boolean isResourceMain() {
		return true;
	}

	public long getOriginalResourcePrimKey() {
		return _originalResourcePrimKey;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getNodeId() {
		return _nodeId;
	}

	@Override
	public void setNodeId(long nodeId) {
		_columnBitmask = -1L;

		if (!_setOriginalNodeId) {
			_setOriginalNodeId = true;

			_originalNodeId = _nodeId;
		}

		_nodeId = nodeId;
	}

	public long getOriginalNodeId() {
		return _originalNodeId;
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		_columnBitmask = -1L;

		if (_originalTitle == null) {
			_originalTitle = _title;
		}

		_title = title;
	}

	public String getOriginalTitle() {
		return GetterUtil.getString(_originalTitle);
	}

	@JSON
	@Override
	public double getVersion() {
		return _version;
	}

	@Override
	public void setVersion(double version) {
		_columnBitmask = -1L;

		if (!_setOriginalVersion) {
			_setOriginalVersion = true;

			_originalVersion = _version;
		}

		_version = version;
	}

	public double getOriginalVersion() {
		return _originalVersion;
	}

	@JSON
	@Override
	public boolean getMinorEdit() {
		return _minorEdit;
	}

	@JSON
	@Override
	public boolean isMinorEdit() {
		return _minorEdit;
	}

	@Override
	public void setMinorEdit(boolean minorEdit) {
		_minorEdit = minorEdit;
	}

	@JSON
	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public void setContent(String content) {
		_content = content;
	}

	@JSON
	@Override
	public String getSummary() {
		if (_summary == null) {
			return "";
		}
		else {
			return _summary;
		}
	}

	@Override
	public void setSummary(String summary) {
		_summary = summary;
	}

	@JSON
	@Override
	public String getFormat() {
		if (_format == null) {
			return "";
		}
		else {
			return _format;
		}
	}

	@Override
	public void setFormat(String format) {
		_columnBitmask |= FORMAT_COLUMN_BITMASK;

		if (_originalFormat == null) {
			_originalFormat = _format;
		}

		_format = format;
	}

	public String getOriginalFormat() {
		return GetterUtil.getString(_originalFormat);
	}

	@JSON
	@Override
	public boolean getHead() {
		return _head;
	}

	@JSON
	@Override
	public boolean isHead() {
		return _head;
	}

	@Override
	public void setHead(boolean head) {
		_columnBitmask |= HEAD_COLUMN_BITMASK;

		if (!_setOriginalHead) {
			_setOriginalHead = true;

			_originalHead = _head;
		}

		_head = head;
	}

	public boolean getOriginalHead() {
		return _originalHead;
	}

	@JSON
	@Override
	public String getParentTitle() {
		if (_parentTitle == null) {
			return "";
		}
		else {
			return _parentTitle;
		}
	}

	@Override
	public void setParentTitle(String parentTitle) {
		_columnBitmask |= PARENTTITLE_COLUMN_BITMASK;

		if (_originalParentTitle == null) {
			_originalParentTitle = _parentTitle;
		}

		_parentTitle = parentTitle;
	}

	public String getOriginalParentTitle() {
		return GetterUtil.getString(_originalParentTitle);
	}

	@JSON
	@Override
	public String getRedirectTitle() {
		if (_redirectTitle == null) {
			return "";
		}
		else {
			return _redirectTitle;
		}
	}

	@Override
	public void setRedirectTitle(String redirectTitle) {
		_columnBitmask |= REDIRECTTITLE_COLUMN_BITMASK;

		if (_originalRedirectTitle == null) {
			_originalRedirectTitle = _redirectTitle;
		}

		_redirectTitle = redirectTitle;
	}

	public String getOriginalRedirectTitle() {
		return GetterUtil.getString(_originalRedirectTitle);
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public long getContainerModelId() {
		return getResourcePrimKey();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_resourcePrimKey = containerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getTitle());
	}

	@Override
	public long getParentContainerModelId() {
		return 0;
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(WikiPage.class.getName()));
	}

	@Override
	public com.liferay.trash.kernel.model.TrashEntry getTrashEntry()
		throws PortalException {

		if (!isInTrash()) {
			return null;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if (Validator.isNotNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException noSuchModelException) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler =
					com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
						getTrashHandler(
							trashHandler.getContainerModelClassName(
								containerModel.getContainerModelId()));

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(
					containerModel.getParentContainerModelId());
			}
		}

		return null;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	/**
	 * @deprecated As of Judson (7.1.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
		return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
			getTrashHandler(getModelClassName());
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInTrashContainer() {
		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if ((trashHandler == null) ||
			Validator.isNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			return false;
		}

		try {
			ContainerModel containerModel =
				trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception exception) {
		}

		return false;
	}

	@Override
	public boolean isInTrashExplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isInTrashImplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return false;
		}

		return true;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), WikiPage.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public WikiPage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, WikiPage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		WikiPageImpl wikiPageImpl = new WikiPageImpl();

		wikiPageImpl.setUuid(getUuid());
		wikiPageImpl.setPageId(getPageId());
		wikiPageImpl.setResourcePrimKey(getResourcePrimKey());
		wikiPageImpl.setGroupId(getGroupId());
		wikiPageImpl.setCompanyId(getCompanyId());
		wikiPageImpl.setUserId(getUserId());
		wikiPageImpl.setUserName(getUserName());
		wikiPageImpl.setCreateDate(getCreateDate());
		wikiPageImpl.setModifiedDate(getModifiedDate());
		wikiPageImpl.setNodeId(getNodeId());
		wikiPageImpl.setTitle(getTitle());
		wikiPageImpl.setVersion(getVersion());
		wikiPageImpl.setMinorEdit(isMinorEdit());
		wikiPageImpl.setContent(getContent());
		wikiPageImpl.setSummary(getSummary());
		wikiPageImpl.setFormat(getFormat());
		wikiPageImpl.setHead(isHead());
		wikiPageImpl.setParentTitle(getParentTitle());
		wikiPageImpl.setRedirectTitle(getRedirectTitle());
		wikiPageImpl.setLastPublishDate(getLastPublishDate());
		wikiPageImpl.setStatus(getStatus());
		wikiPageImpl.setStatusByUserId(getStatusByUserId());
		wikiPageImpl.setStatusByUserName(getStatusByUserName());
		wikiPageImpl.setStatusDate(getStatusDate());

		wikiPageImpl.resetOriginalValues();

		return wikiPageImpl;
	}

	@Override
	public int compareTo(WikiPage wikiPage) {
		int value = 0;

		if (getNodeId() < wikiPage.getNodeId()) {
			value = -1;
		}
		else if (getNodeId() > wikiPage.getNodeId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		value = getTitle().compareToIgnoreCase(wikiPage.getTitle());

		if (value != 0) {
			return value;
		}

		if (getVersion() < wikiPage.getVersion()) {
			value = -1;
		}
		else if (getVersion() > wikiPage.getVersion()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WikiPage)) {
			return false;
		}

		WikiPage wikiPage = (WikiPage)object;

		long primaryKey = wikiPage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalResourcePrimKey = _resourcePrimKey;

		_setOriginalResourcePrimKey = false;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_originalUserId = _userId;

		_setOriginalUserId = false;

		_setModifiedDate = false;
		_originalNodeId = _nodeId;

		_setOriginalNodeId = false;

		_originalTitle = _title;

		_originalVersion = _version;

		_setOriginalVersion = false;

		_originalFormat = _format;

		_originalHead = _head;

		_setOriginalHead = false;

		_originalParentTitle = _parentTitle;

		_originalRedirectTitle = _redirectTitle;

		_originalStatus = _status;

		_setOriginalStatus = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<WikiPage> toCacheModel() {
		WikiPageCacheModel wikiPageCacheModel = new WikiPageCacheModel();

		wikiPageCacheModel.uuid = getUuid();

		String uuid = wikiPageCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			wikiPageCacheModel.uuid = null;
		}

		wikiPageCacheModel.pageId = getPageId();

		wikiPageCacheModel.resourcePrimKey = getResourcePrimKey();

		wikiPageCacheModel.groupId = getGroupId();

		wikiPageCacheModel.companyId = getCompanyId();

		wikiPageCacheModel.userId = getUserId();

		wikiPageCacheModel.userName = getUserName();

		String userName = wikiPageCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			wikiPageCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			wikiPageCacheModel.createDate = createDate.getTime();
		}
		else {
			wikiPageCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			wikiPageCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			wikiPageCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		wikiPageCacheModel.nodeId = getNodeId();

		wikiPageCacheModel.title = getTitle();

		String title = wikiPageCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			wikiPageCacheModel.title = null;
		}

		wikiPageCacheModel.version = getVersion();

		wikiPageCacheModel.minorEdit = isMinorEdit();

		wikiPageCacheModel.content = getContent();

		String content = wikiPageCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			wikiPageCacheModel.content = null;
		}

		wikiPageCacheModel.summary = getSummary();

		String summary = wikiPageCacheModel.summary;

		if ((summary != null) && (summary.length() == 0)) {
			wikiPageCacheModel.summary = null;
		}

		wikiPageCacheModel.format = getFormat();

		String format = wikiPageCacheModel.format;

		if ((format != null) && (format.length() == 0)) {
			wikiPageCacheModel.format = null;
		}

		wikiPageCacheModel.head = isHead();

		wikiPageCacheModel.parentTitle = getParentTitle();

		String parentTitle = wikiPageCacheModel.parentTitle;

		if ((parentTitle != null) && (parentTitle.length() == 0)) {
			wikiPageCacheModel.parentTitle = null;
		}

		wikiPageCacheModel.redirectTitle = getRedirectTitle();

		String redirectTitle = wikiPageCacheModel.redirectTitle;

		if ((redirectTitle != null) && (redirectTitle.length() == 0)) {
			wikiPageCacheModel.redirectTitle = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			wikiPageCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			wikiPageCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		wikiPageCacheModel.status = getStatus();

		wikiPageCacheModel.statusByUserId = getStatusByUserId();

		wikiPageCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = wikiPageCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			wikiPageCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			wikiPageCacheModel.statusDate = statusDate.getTime();
		}
		else {
			wikiPageCacheModel.statusDate = Long.MIN_VALUE;
		}

		return wikiPageCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(4 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<WikiPage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WikiPage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((WikiPage)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<WikiPage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WikiPage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((WikiPage)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, WikiPage>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _originalUuid;
	private long _pageId;
	private long _resourcePrimKey;
	private long _originalResourcePrimKey;
	private boolean _setOriginalResourcePrimKey;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _nodeId;
	private long _originalNodeId;
	private boolean _setOriginalNodeId;
	private String _title;
	private String _originalTitle;
	private double _version;
	private double _originalVersion;
	private boolean _setOriginalVersion;
	private boolean _minorEdit;
	private String _content;
	private String _summary;
	private String _format;
	private String _originalFormat;
	private boolean _head;
	private boolean _originalHead;
	private boolean _setOriginalHead;
	private String _parentTitle;
	private String _originalParentTitle;
	private String _redirectTitle;
	private String _originalRedirectTitle;
	private Date _lastPublishDate;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private WikiPage _escapedModel;

}