/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.engine.impl;

import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.impl.WikiEngineTracker;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.exception.WikiFormatException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.util.WikiCacheHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WikiEngineRenderer.class})
public class WikiEngineRenderer {
    private static final Pattern _editPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE_EDIT\\$\\](.*?)\\[\\$END_PAGE_TITLE_EDIT\\$\\]");
    private static final Pattern _viewPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE\\$\\](.*?)\\[\\$END_PAGE_TITLE\\$\\]");
    private WikiCacheHelper _wikiCacheHelper;
    private WikiEngineTracker _wikiEngineTracker;

    public String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException, WikiFormatException {
        LiferayPortletURL liferayViewPageURL = (LiferayPortletURL)viewPageURL;
        LiferayPortletURL liferayEditPageURL = (LiferayPortletURL)editPageURL;
        WikiEngine wikiEngine = this.fetchWikiEngine(page.getFormat());
        if (wikiEngine == null) {
            this._wikiCacheHelper.clearCache(page.getNodeId(), page.getTitle());
            throw new WikiFormatException();
        }
        String content = wikiEngine.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        String editPageURLString = "";
        if (editPageURL != null) {
            liferayEditPageURL.setParameter("title", "__REPLACEMENT__", false);
            editPageURLString = editPageURL.toString();
            editPageURLString = StringUtil.replace((String)editPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        Matcher matcher = _editPageURLPattern.matcher(content);
        content = this._convertURLs(editPageURLString, matcher);
        String viewPageURLString = "";
        if (viewPageURL != null) {
            liferayViewPageURL.setParameter("title", "__REPLACEMENT__", false);
            viewPageURLString = viewPageURL.toString();
            viewPageURLString = StringUtil.replace((String)viewPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        matcher = _viewPageURLPattern.matcher(content);
        content = this._convertURLs(viewPageURLString, matcher);
        content = this._replaceAttachments(content, page.getTitle(), attachmentURLPrefix);
        return content;
    }

    public String diffHtml(WikiPage sourcePage, WikiPage targetPage, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws Exception {
        String sourceContent = "";
        String targetContent = "";
        if (sourcePage != null) {
            sourceContent = this.convert(sourcePage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        if (targetPage != null) {
            targetContent = this.convert(targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        return DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceContent), (Reader)new UnsyncStringReader(targetContent));
    }

    public WikiEngine fetchWikiEngine(String format) {
        return this._wikiEngineTracker.getWikiEngine(format);
    }

    public List<WikiPage> filterOrphans(List<WikiPage> pages) throws PortalException {
        ArrayList<Map<String, Boolean>> pageTitles = new ArrayList<Map<String, Boolean>>();
        for (WikiPage wikiPage : pages) {
            pageTitles.add(this._wikiCacheHelper.getOutgoingLinks(wikiPage, this));
        }
        HashSet<WikiPage> notOrphans = new HashSet<WikiPage>();
        block1: for (WikiPage page : pages) {
            for (Map map2 : pageTitles) {
                String pageTitleLowerCase = page.getTitle();
                if (map2.get(pageTitleLowerCase = StringUtil.toLowerCase((String)pageTitleLowerCase)) == null) continue;
                notOrphans.add(page);
                continue block1;
            }
        }
        ArrayList<WikiPage> arrayList = new ArrayList<WikiPage>();
        for (WikiPage page : pages) {
            if (notOrphans.contains(page)) continue;
            arrayList.add(page);
        }
        List list = ListUtil.sort(arrayList);
        return list;
    }

    public String getFormatLabel(String format, Locale locale) {
        WikiEngine wikiEngine = this.fetchWikiEngine(format);
        if (wikiEngine != null) {
            return wikiEngine.getFormatLabel(locale);
        }
        return "";
    }

    public Collection<String> getFormats() {
        return this._wikiEngineTracker.getFormats();
    }

    public String getFormattedContent(RenderRequest renderRequest, RenderResponse renderResponse, WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String title2, boolean preview) throws Exception {
        WikiPageDisplay pageDisplay;
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        double version = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"version");
        PortletURL curViewPageURL = PortletURLUtil.clone((PortletURL)viewPageURL, (MimeResponse)renderResponse);
        PortletURL curEditPageURL = PortletURLUtil.clone((PortletURL)editPageURL, (MimeResponse)renderResponse);
        StringBundler sb = new StringBundler(8);
        sb.append(themeDisplay.getPathMain());
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(themeDisplay.getPlid());
        sb.append("&nodeId=");
        sb.append(page.getNodeId());
        sb.append("&title=");
        sb.append(URLCodec.encodeURL((String)page.getTitle()));
        sb.append("&fileName=");
        String attachmentURLPrefix = sb.toString();
        if (!preview && version == 0.0 && (pageDisplay = this._wikiCacheHelper.getDisplay(page.getNodeId(), title2, curViewPageURL, curEditPageURL, attachmentURLPrefix)) != null) {
            return pageDisplay.getFormattedContent();
        }
        return this.convert(page, curViewPageURL, curEditPageURL, attachmentURLPrefix);
    }

    public void renderEditPageHTML(String format, PageContext pageContext, WikiNode node, WikiPage page) throws IOException, ServletException, WikiFormatException {
        WikiEngine wikiEngine = this._wikiEngineTracker.getWikiEngine(format);
        if (wikiEngine == null) {
            this._wikiCacheHelper.clearCache(page.getNodeId(), page.getTitle());
            throw new WikiFormatException();
        }
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        wikiEngine.renderEditPage(pageContext.getRequest(), (ServletResponse)pipingServletResponse, node, page);
        JspWriter writer = pageContext.getOut();
        StringBundler sb = unsyncStringWriter.getStringBundler();
        writer.write(sb.toString());
    }

    @Reference(unbind="-")
    protected void setWikiCacheHelper(WikiCacheHelper wikiCacheHelper) {
        this._wikiCacheHelper = wikiCacheHelper;
    }

    @Reference(unbind="-")
    protected void setWikiEngineTracker(WikiEngineTracker wikiEngineTracker) {
        this._wikiEngineTracker = wikiEngineTracker;
    }

    private String _convertURLs(String url, Matcher matcher) {
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = null;
            if (matcher.groupCount() >= 1) {
                String encodedTitle = URLCodec.encodeURL((String)HtmlUtil.unescape((String)matcher.group(1)));
                replacement = url.replace("$1", encodedTitle);
            } else {
                replacement = url;
            }
            matcher.appendReplacement(sb, replacement);
        }
        return matcher.appendTail(sb).toString();
    }

    private String _replaceAttachments(String content, String title2, String attachmentURLPrefix) {
        content = StringUtil.replace((String)content, (String)"[$WIKI_PAGE_NAME$]", (String)title2);
        content = StringUtil.replace((String)content, (String)"[$ATTACHMENT_URL_PREFIX$]", (String)attachmentURLPrefix);
        return content;
    }
}

