/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.engine.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.wiki.engine.WikiEngine;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={WikiEngineTracker.class})
public class WikiEngineTracker {
    private static final Log _log = LogFactoryUtil.getLog(WikiEngineTracker.class);
    private BundleContext _bundleContext;
    private ServiceTrackerMap<String, List<WikiEngine>> _serviceTrackerMap;

    public Collection<String> getFormats() {
        return this._serviceTrackerMap.keySet();
    }

    public WikiEngine getWikiEngine(String format) {
        List wikiEngines = (List)this._serviceTrackerMap.getService((Object)format);
        if (wikiEngines == null) {
            return null;
        }
        return (WikiEngine)wikiEngines.get(0);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, WikiEngine.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, WikiEngine>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void map(ServiceReference<WikiEngine> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                WikiEngine wikiEngine = (WikiEngine)WikiEngineTracker.this._bundleContext.getService(serviceReference);
                try {
                    emitter.emit((Object)wikiEngine.getFormat());
                }
                finally {
                    WikiEngineTracker.this._bundleContext.ungetService(serviceReference);
                }
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

