/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.importer.impl;

import com.liferay.wiki.importer.WikiImporter;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={WikiImporterTracker.class})
public class WikiImporterTracker {
    private BundleContext _bundleContext;
    private final ConcurrentMap<String, ServiceReference<WikiImporter>> _serviceReferences = new ConcurrentSkipListMap<String, ServiceReference<WikiImporter>>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=WikiImporter.class, unbind="removedService", updated="modifiedService")
    public void addingService(ServiceReference<WikiImporter> serviceReference) {
        String format = (String)serviceReference.getProperty("importer");
        this._serviceReferences.put(format, serviceReference);
    }

    public Collection<String> getImporters() {
        return this._serviceReferences.keySet();
    }

    public String getProperty(String importer, String key) {
        ServiceReference serviceReference = (ServiceReference)this._serviceReferences.get(importer);
        return (String)serviceReference.getProperty(key);
    }

    public WikiImporter getWikiImporter(String importer) {
        return (WikiImporter)this._bundleContext.getService((ServiceReference)this._serviceReferences.get(importer));
    }

    public void modifiedService(ServiceReference<WikiImporter> serviceReference) {
        this.removedService(serviceReference);
        this.addingService(serviceReference);
    }

    public void removedService(ServiceReference<WikiImporter> serviceReference) {
        String importer = (String)serviceReference.getProperty("importer");
        this._serviceReferences.remove(importer);
    }

    @Activate
    protected void activate() {
        Bundle bundle = FrameworkUtil.getBundle(WikiImporterTracker.class);
        this._bundleContext = bundle.getBundleContext();
    }
}

