/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.importer.impl.mediawiki;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.engine.impl.WikiEngineRenderer;
import com.liferay.wiki.exception.ImportFilesException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.importer.WikiImporter;
import com.liferay.wiki.internal.translator.MediaWikiToCreoleTranslator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.validator.WikiPageTitleValidator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"importer=MediaWiki", "page=/wiki/import/mediawiki.jsp"}, service={WikiImporter.class})
public class MediaWikiImporter
implements WikiImporter {
    public static final String FORMAT_CREOLE = "creole";
    public static final String FORMAT_MEDIAWIKI = "mediawiki";
    public static final String SHARED_IMAGES_CONTENT = "See attachments";
    public static final String SHARED_IMAGES_TITLE = "SharedImages";
    private static final String _WORK_IN_PROGRESS = "{{Work in progress}}";
    private static final String _WORK_IN_PROGRESS_TAG = "work in progress";
    private static final Log _log = LogFactoryUtil.getLog(MediaWikiImporter.class);
    private static final Pattern _categoriesPattern = Pattern.compile("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*");
    private static final Pattern _imagesPattern = Pattern.compile("(\\[\\[Image|File)(:)([^\\]]*)(\\]\\])", 32);
    private static final Pattern _parentPattern = Pattern.compile("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}");
    private static final Pattern _redirectPattern = Pattern.compile("#REDIRECT \\[\\[([^\\]]*)\\]\\]");
    private static final Set<String> _specialMediaWikiDirs = SetUtil.fromArray((Object[])new String[]{"archive", "temp", "thumb"});
    private AssetTagLocalService _assetTagLocalService;
    private final MediaWikiToCreoleTranslator _translator = new MediaWikiToCreoleTranslator();
    private UserLocalService _userLocalService;
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    private WikiPageLocalService _wikiPageLocalService;
    private WikiPageTitleValidator _wikiPageTitleValidator;

    public void importPages(long userId, WikiNode node, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        if (inputStreams.length < 1 || inputStreams[0] == null) {
            throw new PortalException("The pages file is mandatory");
        }
        InputStream pagesInputStream = inputStreams[0];
        InputStream usersInputStream = null;
        if (inputStreams.length > 1) {
            usersInputStream = inputStreams[1];
        }
        InputStream imagesInputStream = null;
        if (inputStreams.length > 2) {
            imagesInputStream = inputStreams[2];
        }
        try {
            Document document = SAXReaderUtil.read((InputStream)pagesInputStream);
            Map<String, String> usersMap = this.readUsersFile(usersInputStream);
            Element rootElement = document.getRootElement();
            List<String> specialNamespaces = this.readSpecialNamespaces(rootElement);
            this.processSpecialPages(userId, node, rootElement, specialNamespaces);
            this.processRegularPages(userId, node, rootElement, specialNamespaces, usersMap, imagesInputStream, options);
            this.processImages(userId, node, imagesInputStream);
            this.moveFrontPage(userId, node, options);
        }
        catch (DocumentException de) {
            throw new ImportFilesException("Invalid XML file provided");
        }
        catch (IOException ioe) {
            throw new ImportFilesException("Error reading the files provided");
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    protected String getCreoleRedirectContent(String redirectTitle) {
        return "[[" + redirectTitle + "]]";
    }

    protected long getUserId(long userId, WikiNode node, String author, Map<String, String> usersMap) {
        User user = null;
        String emailAddress = usersMap.get(author);
        user = Validator.isNotNull((String)emailAddress) ? this._userLocalService.fetchUserByEmailAddress(node.getCompanyId(), emailAddress) : this._userLocalService.fetchUserByScreenName(node.getCompanyId(), StringUtil.toLowerCase((String)author));
        if (user != null) {
            return user.getUserId();
        }
        return userId;
    }

    protected void importPage(long userId, String author, WikiNode node, String title2, String content, String summary, Map<String, String> usersMap, boolean strictImportMode) throws PortalException {
        try {
            long authorUserId = this.getUserId(userId, node, author, usersMap);
            String parentTitle = this.readParentTitle(content);
            String redirectTitle = this.readRedirectTitle(content);
            String format = FORMAT_MEDIAWIKI;
            Collection<String> supportedFormats = this._wikiEngineRenderer.getFormats();
            if (Validator.isNotNull((String)redirectTitle)) {
                content = this.getCreoleRedirectContent(redirectTitle);
                format = FORMAT_CREOLE;
            } else if (supportedFormats.contains(FORMAT_MEDIAWIKI) && Objects.equals(this._wikiGroupServiceConfiguration.defaultFormat(), FORMAT_MEDIAWIKI)) {
                content = this.translateMediaWikiImagePaths(content);
            } else {
                content = this.translateMediaWikiToCreole(content, strictImportMode);
                format = FORMAT_CREOLE;
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setAssetTagNames(this.readAssetTagNames(userId, node, content));
            WikiPage page = null;
            try {
                page = this._wikiPageLocalService.getPage(node.getNodeId(), title2);
            }
            catch (NoSuchPageException nspe) {
                page = this._wikiPageLocalService.addPage(authorUserId, node.getNodeId(), title2, "New", null, true, serviceContext);
            }
            this._wikiPageLocalService.updatePage(authorUserId, node.getNodeId(), title2, page.getVersion(), content, summary, true, format, parentTitle, redirectTitle, serviceContext);
        }
        catch (Exception e) {
            throw new PortalException("Error importing page " + title2, (Throwable)e);
        }
    }

    protected boolean isSpecialMediaWikiPage(String title2, List<String> specialNamespaces) {
        for (String namespace : specialNamespaces) {
            if (!title2.startsWith(namespace + ":")) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidImage(String[] paths, InputStream inputStream) {
        if (_specialMediaWikiDirs.contains(paths[0])) {
            return false;
        }
        if (paths.length > 1 && _specialMediaWikiDirs.contains(paths[1])) {
            return false;
        }
        String fileName = paths[paths.length - 1];
        try {
            DLStoreUtil.validate((String)fileName, (boolean)true, (InputStream)inputStream);
        }
        catch (PortalException | SystemException e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, e);
            }
            return false;
        }
        return true;
    }

    protected void moveFrontPage(long userId, WikiNode node, Map<String, String[]> options) {
        block4: {
            String frontPageTitle = MapUtil.getString(options, (String)"OPTIONS_FRONT_PAGE");
            if (Validator.isNotNull((String)frontPageTitle)) {
                frontPageTitle = this._wikiPageTitleValidator.normalize(frontPageTitle);
                try {
                    if (this._wikiPageLocalService.getPagesCount(node.getNodeId(), frontPageTitle, true) > 0) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setAddGroupPermissions(true);
                        serviceContext.setAddGuestPermissions(true);
                        this._wikiPageLocalService.renamePage(userId, node.getNodeId(), frontPageTitle, this._wikiGroupServiceConfiguration.frontPageName(), false, serviceContext);
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    StringBundler sb = new StringBundler(4);
                    sb.append("Could not move ");
                    sb.append(this._wikiGroupServiceConfiguration.frontPageName());
                    sb.append(" to the title provided: ");
                    sb.append(frontPageTitle);
                    _log.warn((Object)sb.toString(), (Throwable)e);
                }
            }
        }
    }

    protected String normalize(String categoryName, int length) {
        categoryName = AssetUtil.toWord((String)categoryName.trim());
        return StringUtil.shorten((String)categoryName, (int)length);
    }

    protected String normalizeDescription(String description) {
        Matcher matcher = _categoriesPattern.matcher(description);
        description = matcher.replaceAll("");
        return this.normalize(description, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processImages(long userId, WikiNode node, InputStream imagesInputStream) throws Exception {
        if (imagesInputStream == null) {
            return;
        }
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)imagesInputStream);
        List entries = zipReader.getEntries();
        if (entries == null) {
            throw new ImportFilesException();
        }
        int total = entries.size();
        if (total > 0) {
            try {
                this._wikiPageLocalService.getPage(node.getNodeId(), SHARED_IMAGES_TITLE);
            }
            catch (NoSuchPageException nspe) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                this._wikiPageLocalService.addPage(userId, node.getNodeId(), SHARED_IMAGES_TITLE, SHARED_IMAGES_CONTENT, null, true, serviceContext);
            }
        }
        ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>();
        try {
            int percentage = 50;
            for (int i2 = 0; i2 < entries.size(); ++i2) {
                String entry;
                String key = entry = (String)entries.get(i2);
                InputStream inputStream = zipReader.getEntryAsInputStream(entry);
                String[] paths = StringUtil.split((String)key, (char)'/');
                if (!this.isValidImage(paths, inputStream)) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Ignoring " + key));
                    continue;
                }
                String fileName = StringUtil.toLowerCase((String)paths[paths.length - 1]);
                ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                inputStreamOVPs.add(inputStreamOVP);
                ++count;
                if (i2 % 5 != 0) continue;
                this._wikiPageLocalService.addPageAttachments(userId, node.getNodeId(), SHARED_IMAGES_TITLE, inputStreamOVPs);
                inputStreamOVPs.clear();
                percentage = Math.min(50 + i2 * 50 / total, 99);
                if (progressTracker == null) continue;
                progressTracker.setPercent(percentage);
            }
            if (!inputStreamOVPs.isEmpty()) {
                this._wikiPageLocalService.addPageAttachments(userId, node.getNodeId(), SHARED_IMAGES_TITLE, inputStreamOVPs);
            }
        }
        catch (Throwable throwable) {
            for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
                InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            throw throwable;
        }
        for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        zipReader.close();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Imported " + count + " images into " + node.getName()));
        }
    }

    protected void processRegularPages(long userId, WikiNode node, Element rootElement, List<String> specialNamespaces, Map<String, String> usersMap, InputStream imagesInputStream, Map<String, String[]> options) {
        boolean importLatestVersion = MapUtil.getBoolean(options, (String)"OPTIONS_IMPORT_LATEST_VERSION");
        boolean strictImportMode = MapUtil.getBoolean(options, (String)"OPTIONS_STRICT_IMPORT_MODE");
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        int percentage = 10;
        int maxPercentage = 50;
        if (imagesInputStream == null) {
            maxPercentage = 99;
        }
        List pageElements = rootElement.elements("page");
        for (int i2 = 0; i2 < pageElements.size(); ++i2) {
            Element pageElement = (Element)pageElements.get(i2);
            String title2 = pageElement.elementText("title");
            if (this.isSpecialMediaWikiPage(title2, specialNamespaces)) continue;
            title2 = this._wikiPageTitleValidator.normalize(title2);
            percentage = Math.min(10 + i2 * (maxPercentage - percentage) / pageElements.size(), maxPercentage);
            progressTracker.setPercent(percentage);
            ArrayList<Element> revisionElements = pageElement.elements("revision");
            if (importLatestVersion) {
                Element lastRevisionElement = (Element)revisionElements.get(revisionElements.size() - 1);
                revisionElements = new ArrayList<Element>();
                revisionElements.add(lastRevisionElement);
            }
            for (Element revisionElement : revisionElements) {
                Element contributorElement = revisionElement.element("contributor");
                String author = contributorElement.elementText("username");
                String content = revisionElement.elementText("text");
                String summary = revisionElement.elementText("comment");
                try {
                    this.importPage(userId, author, node, title2, content, summary, usersMap, strictImportMode);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Page with title " + title2 + " could not be imported"), (Throwable)e);
                }
            }
            ++count;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Imported " + count + " pages into " + node.getName()));
        }
    }

    protected void processSpecialPages(long userId, WikiNode node, Element rootElement, List<String> specialNamespaces) throws PortalException {
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        List pageElements = rootElement.elements("page");
        for (int i2 = 0; i2 < pageElements.size(); ++i2) {
            Element pageElement = (Element)pageElements.get(i2);
            String title2 = pageElement.elementText("title");
            if (!title2.startsWith("Category:")) {
                if (!this.isSpecialMediaWikiPage(title2, specialNamespaces)) continue;
                rootElement.remove(pageElement);
                continue;
            }
            String categoryName = title2.substring("Category:".length());
            categoryName = this.normalize(categoryName, 75);
            this._assetTagLocalService.checkTags(userId, node.getGroupId(), new String[]{categoryName});
            if (i2 % 5 != 0) continue;
            progressTracker.setPercent(i2 * 10 / pageElements.size());
        }
    }

    protected String[] readAssetTagNames(long userId, WikiNode node, String content) throws PortalException {
        Matcher matcher = _categoriesPattern.matcher(content);
        ArrayList<String> assetTagNames = new ArrayList<String>();
        while (matcher.find()) {
            String categoryName = matcher.group(1);
            categoryName = this.normalize(categoryName, 75);
            List assetTags = this._assetTagLocalService.checkTags(userId, node.getGroupId(), new String[]{categoryName});
            assetTagNames.addAll(ListUtil.toList((List)assetTags, (Accessor)AssetTag.NAME_ACCESSOR));
        }
        if (content.contains(_WORK_IN_PROGRESS)) {
            assetTagNames.add(_WORK_IN_PROGRESS_TAG);
        }
        return assetTagNames.toArray(new String[assetTagNames.size()]);
    }

    protected String readParentTitle(String content) {
        Matcher matcher = _parentPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this._wikiPageTitleValidator.normalize(redirectTitle);
            redirectTitle = redirectTitle + " (disambiguation)";
        }
        return redirectTitle;
    }

    protected String readRedirectTitle(String content) {
        Matcher matcher = _redirectPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this._wikiPageTitleValidator.normalize(redirectTitle);
        }
        return redirectTitle;
    }

    protected List<String> readSpecialNamespaces(Element root) throws ImportFilesException {
        ArrayList<String> namespaces = new ArrayList<String>();
        Element siteinfoElement = root.element("siteinfo");
        if (siteinfoElement == null) {
            throw new ImportFilesException("Invalid pages XML file");
        }
        Element namespacesElement = siteinfoElement.element("namespaces");
        List namespaceElements = namespacesElement.elements("namespace");
        for (Element namespaceElement : namespaceElements) {
            Attribute attribute = namespaceElement.attribute("key");
            String value = attribute.getValue();
            if (value.equals("0")) continue;
            namespaces.add(namespaceElement.getText());
        }
        return namespaces;
    }

    protected Map<String, String> readUsersFile(InputStream usersInputStream) throws IOException {
        if (usersInputStream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> usersMap = new HashMap<String, String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(usersInputStream));
        String line = unsyncBufferedReader.readLine();
        while (line != null) {
            String[] array = StringUtil.split((String)line);
            if (array.length == 2 && Validator.isNotNull((String)array[0]) && Validator.isNotNull((String)array[1])) {
                usersMap.put(array[0], array[1]);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("Ignoring line " + line + " because it does not contain exactly 2 columns"));
            }
            line = unsyncBufferedReader.readLine();
        }
        return usersMap;
    }

    @Reference(unbind="-")
    protected void setAssetTagLocalService(AssetTagLocalService assetTagLocalService) {
        this._assetTagLocalService = assetTagLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiGroupServiceConfiguration(WikiGroupServiceConfiguration wikiGroupServiceConfiguration) {
        this._wikiGroupServiceConfiguration = wikiGroupServiceConfiguration;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageTitleValidator(WikiPageTitleValidator wikiPageTitleValidator) {
        this._wikiPageTitleValidator = wikiPageTitleValidator;
    }

    protected String translateMediaWikiImagePaths(String content) {
        return content.replaceAll(_imagesPattern.pattern(), "$1$2SharedImages/$3$4");
    }

    protected String translateMediaWikiToCreole(String content, boolean strictImportMode) {
        this._translator.setStrictImportMode(strictImportMode);
        return this._translator.translate(content);
    }
}

