/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.convert.documentlibrary;

import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.convert.documentlibrary.DLStoreConverter;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class WikiDLStoreConvertProcess
implements DLStoreConvertProcess {
    private WikiPageLocalService _wikiPageLocalService;

    public void migrate(final DLStoreConverter dlStoreConverter) throws PortalException {
        int count = this._wikiPageLocalService.getWikiPagesCount();
        MaintenanceUtil.appendStatus((String)("Migrating wiki page attachments in " + count + " pages"));
        ActionableDynamicQuery actionableDynamicQuery = this._wikiPageLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"head");
                dynamicQuery.add(property.eq((Object)true));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<WikiPage>(){

            public void performAction(WikiPage wikiPage) throws PortalException {
                for (FileEntry fileEntry : wikiPage.getAttachmentsFileEntries()) {
                    dlStoreConverter.migrateDLFileEntry(wikiPage.getCompanyId(), DLFolderConstants.getDataRepositoryId((long)fileEntry.getRepositoryId(), (long)fileEntry.getFolderId()), fileEntry);
                }
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    public void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

