/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.wiki.internal.exportimport.content.processor.WikiPageExportImportContentProcessor;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class WikiPageStagedModelDataHandler
extends BaseStagedModelDataHandler<WikiPage> {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(WikiPageStagedModelDataHandler.class);
    private WikiPageExportImportContentProcessor _wikiPageExportImportContentProcessor;
    private WikiPageLocalService _wikiPageLocalService;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        WikiPageResource pageResource = this._wikiPageResourceLocalService.fetchWikiPageResourceByUuidAndGroupId(uuid, groupId);
        if (pageResource == null) {
            return;
        }
        WikiPage latestPage = this._wikiPageLocalService.getLatestPage(pageResource.getResourcePrimKey(), -1, true);
        this.deleteStagedModel(latestPage);
    }

    public void deleteStagedModel(WikiPage page) throws PortalException {
        this._wikiPageLocalService.deletePage(page);
    }

    public WikiPage fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._wikiPageLocalService.fetchWikiPageByUuidAndGroupId(uuid, groupId);
    }

    public List<WikiPage> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._wikiPageLocalService.getWikiPagesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        Element pageElement = portletDataContext.getExportDataElement((ClassedModel)page);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)page, (StagedModel)page.getNode(), (String)"parent");
        String content = this._wikiPageExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)page, page.getContent(), portletDataContext.getBooleanParameter("wiki", "referenced-content"), true);
        page.setContent(content);
        if (page.isHead()) {
            for (FileEntry fileEntry : page.getAttachmentsFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)page, (StagedModel)fileEntry, (String)"weak");
            }
        }
        WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(page.getResourcePrimKey());
        pageElement.addAttribute("page-resource-uuid", pageResource.getUuid());
        portletDataContext.addClassedModel(pageElement, ExportImportPathUtil.getModelPath((StagedModel)page), (ClassedModel)page);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long pageId) throws Exception {
        WikiPage existingPage = (WikiPage)this.fetchMissingReference(uuid, groupId);
        if (existingPage == null) {
            return;
        }
        Map pageIds = portletDataContext.getNewPrimaryKeysMap(WikiPage.class);
        pageIds.put(pageId, existingPage.getPageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        Element pageElement = portletDataContext.getImportDataStagedModelElement((StagedModel)page);
        String content = this._wikiPageExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)page, page.getContent());
        page.setContent(content);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)page);
        serviceContext.setUuid(page.getUuid());
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        long nodeId = MapUtil.getLong((Map)nodeIds, (long)page.getNodeId(), (long)page.getNodeId());
        WikiPage importedPage = null;
        WikiPage existingPage = this._wikiPageLocalService.fetchPage(nodeId, page.getTitle());
        if (existingPage == null) {
            importedPage = this._wikiPageLocalService.addPage(userId, nodeId, page.getTitle(), page.getVersion(), page.getContent(), page.getSummary(), page.isMinorEdit(), page.getFormat(), page.getHead(), page.getParentTitle(), page.getRedirectTitle(), serviceContext);
            WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(importedPage.getResourcePrimKey());
            String pageResourceUuid = GetterUtil.getString((String)pageElement.attributeValue("page-resource-uuid"));
            if (Validator.isNotNull((String)pageResourceUuid)) {
                pageResource.setUuid(pageElement.attributeValue("page-resource-uuid"));
                this._wikiPageResourceLocalService.updateWikiPageResource(pageResource);
            }
        } else {
            existingPage = this.fetchStagedModelByUuidAndGroupId(page.getUuid(), portletDataContext.getScopeGroupId());
            if (existingPage == null) {
                existingPage = this._wikiPageLocalService.fetchPage(nodeId, page.getTitle(), page.getVersion());
            }
            importedPage = existingPage == null ? this._wikiPageLocalService.updatePage(userId, nodeId, page.getTitle(), 0.0, page.getContent(), page.getSummary(), page.isMinorEdit(), page.getFormat(), page.getParentTitle(), page.getRedirectTitle(), serviceContext) : existingPage;
        }
        if (page.isHead()) {
            List attachmentElements = portletDataContext.getReferenceDataElements(pageElement, DLFileEntry.class, "weak");
            for (Element attachmentElement : attachmentElements) {
                InputStream inputStream;
                FileEntry fileEntry;
                block14: {
                    block15: {
                        String path = attachmentElement.attributeValue("path");
                        fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
                        inputStream = null;
                        try {
                            String binPath = attachmentElement.attributeValue("bin-path");
                            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                                try {
                                    inputStream = FileEntryUtil.getContentStream((FileEntry)fileEntry);
                                }
                                catch (NoSuchFileException nsfe) {
                                    if (_log.isDebugEnabled()) {
                                        _log.debug((Object)nsfe, (Throwable)nsfe);
                                    }
                                }
                            } else {
                                inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                            }
                            if (inputStream != null) break block14;
                            if (!_log.isWarnEnabled()) break block15;
                            _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                        }
                        catch (Throwable throwable) {
                            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                            throw throwable;
                        }
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    continue;
                }
                this._wikiPageLocalService.addPageAttachment(userId, importedPage.getNodeId(), importedPage.getTitle(), fileEntry.getTitle(), inputStream, null);
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
        }
        portletDataContext.importClassedModel((ClassedModel)page, (ClassedModel)importedPage);
        Map pageIds = portletDataContext.getNewPrimaryKeysMap(WikiPage.class + ".pageId");
        pageIds.put(page.getPageId(), importedPage.getPageId());
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        WikiPage existingPage = this.fetchStagedModelByUuidAndGroupId(page.getUuid(), portletDataContext.getScopeGroupId());
        if (existingPage == null || !existingPage.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingPage.getTrashHandler();
        if (trashHandler.isRestorable(existingPage.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(userId, existingPage.getResourcePrimKey());
        }
    }

    @Reference(unbind="-")
    protected void setWikiPageExportImportContentProcessor(WikiPageExportImportContentProcessor wikiPageExportImportContentProcessor) {
        this._wikiPageExportImportContentProcessor = wikiPageExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }
}

