/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.translator;

import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseTranslator {
    protected List<String> nowikiRegexps = new LinkedList<String>();
    protected Map<String, String> regexps = new LinkedHashMap<String, String>();
    private final Map<String, String> _protectedMap = new LinkedHashMap<String, String>();

    public String translate(String content) {
        this._protectedMap.clear();
        content = this.preProcess(content);
        content = this.runRegexps(content);
        content = this.postProcess(content);
        return content;
    }

    protected String postProcess(String content) {
        return this.unprotectNowikiText(content);
    }

    protected String preProcess(String content) {
        content = this._normalizeLineBreaks(content);
        for (String regexp : this.nowikiRegexps) {
            content = this.protectText(content, regexp);
        }
        return content;
    }

    protected String protectText(String content, String markupRegex) {
        Pattern pattern = Pattern.compile(markupRegex, 40);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String protectedText = matcher.group();
            String hash = DigesterUtil.digest((String)protectedText);
            matcher.appendReplacement(sb, "$1" + hash + "$3");
            this._protectedMap.put(hash, matcher.group(2));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String runRegexp(String content, String regexp, String replacement) {
        Pattern pattern = Pattern.compile(regexp, 8);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String runRegexps(String content) {
        for (Map.Entry<String, String> entry : this.regexps.entrySet()) {
            String regexp = entry.getKey();
            String replacement = entry.getValue();
            content = this.runRegexp(content, regexp, replacement);
        }
        return content;
    }

    protected String unprotectNowikiText(String content) {
        for (Map.Entry<String, String> entry : this._protectedMap.entrySet()) {
            String hash = entry.getKey();
            String protectedMarkup = entry.getValue();
            content = content.replace(hash, protectedMarkup);
        }
        return content;
    }

    private String _normalizeLineBreaks(String content) {
        content = StringUtil.replace((String)content, (String[])new String[]{"\r\n", "\r"}, (String[])new String[]{"\n", "\n"});
        return content;
    }
}

