/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.validator;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.exception.PageTitleException;
import com.liferay.wiki.validator.WikiPageTitleValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class DefaultWikiPageTitleValidator
implements WikiPageTitleValidator {
    private static final Pattern _pageTitlePattern = Pattern.compile("[^\\\\\\[\\]\\|:;%<>]+");
    private static final Pattern _pageTitleRemovePattern = Pattern.compile("[\\\\\\[\\]\\|:;%<>]+");

    public String normalize(String title2) {
        Matcher matcher = _pageTitleRemovePattern.matcher(title2);
        title2 = matcher.replaceAll("");
        return StringUtil.shorten((String)title2, (int)255);
    }

    public void validate(String title2) throws PageTitleException {
        if (title2.equals("all_pages") || title2.equals("orphan_pages") || title2.equals("recent_changes")) {
            throw new PageTitleException(title2 + " is reserved");
        }
        Matcher matcher = _pageTitlePattern.matcher(title2);
        if (!matcher.matches()) {
            throw new PageTitleException();
        }
    }
}

