/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.verify;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.kernel.verify.model.VerifiableUUIDModel;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.VerifyResourcePermissions;
import com.liferay.portal.verify.VerifyUUID;
import com.liferay.wiki.internal.verify.model.WikiNodeVerifiableModel;
import com.liferay.wiki.internal.verify.model.WikiPageResourceVerifiableModel;
import com.liferay.wiki.internal.verify.model.WikiPageVerifiableModel;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import com.liferay.wiki.util.comparator.PageVersionComparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.wiki.service"}, service={VerifyProcess.class})
public class WikiServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(WikiServiceVerifyProcess.class);
    private final VerifyResourcePermissions _verifyResourcePermissions = new VerifyResourcePermissions();
    private WikiPageLocalService _wikiPageLocalService;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;

    protected void doVerify() throws Exception {
        this.verifyCreateDate();
        this.verifyNoAssetPages();
        this.verifyResourcedModels();
        this.verifyUUIDModels();
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }

    protected void verifyCreateDate() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._wikiPageResourceLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<WikiPageResource>(){

                public void performAction(WikiPageResource pageResource) {
                    WikiServiceVerifyProcess.this.verifyCreateDate(pageResource);
                }
            });
            actionableDynamicQuery.performActions();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Create dates verified for pages");
            }
        }
    }

    protected void verifyCreateDate(WikiPageResource pageResource) {
        List pages = this._wikiPageLocalService.getPages(pageResource.getNodeId(), pageResource.getTitle(), -1, -1, (OrderByComparator)new PageVersionComparator(true));
        if (pages.size() <= 1) {
            return;
        }
        WikiPage firstPage = (WikiPage)pages.get(0);
        Date createDate = firstPage.getCreateDate();
        for (WikiPage page : pages) {
            if (createDate.equals(page.getCreateDate())) continue;
            page.setCreateDate(createDate);
            this._wikiPageLocalService.updateWikiPage(page);
        }
    }

    protected void verifyNoAssetPages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List pages = this._wikiPageLocalService.getNoAssetPages();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + pages.size() + " pages with no asset"));
            }
            for (WikiPage page : pages) {
                try {
                    this._wikiPageLocalService.updateAsset(page.getUserId(), page, null, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to update asset for page " + page.getPageId() + ": " + e.getMessage()));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for pages");
            }
        }
    }

    protected void verifyResourcedModels() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._verifyResourcePermissions.verify(new VerifiableResourcedModel[]{new WikiNodeVerifiableModel()});
            this._verifyResourcePermissions.verify(new VerifiableResourcedModel[]{new WikiPageVerifiableModel()});
        }
    }

    protected void verifyUUIDModels() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            VerifyUUID.verify((VerifiableUUIDModel[])new VerifiableUUIDModel[]{new WikiPageResourceVerifiableModel()});
        }
    }
}

