/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.impl.WikiNodeImpl;
import com.liferay.wiki.model.impl.WikiPageBaseImpl;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.service.WikiPageServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WikiPageImpl
extends WikiPageBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(WikiPageImpl.class);
    private long _attachmentsFolderId;

    public Folder addAttachmentsFolder() throws PortalException {
        if (this._attachmentsFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFolder((long)this._attachmentsFolderId);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)this.getGroupId(), (String)"com.liferay.wiki", (ServiceContext)serviceContext);
        WikiNode node = this.getNode();
        Folder nodeFolder = node.addAttachmentsFolder();
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)this.getUserId(), (long)repository.getRepositoryId(), (long)nodeFolder.getFolderId(), (String)String.valueOf(this.getResourcePrimKey()), (ServiceContext)serviceContext);
        this._attachmentsFolderId = folder.getFolderId();
        return folder;
    }

    public WikiPage fetchParentPage() {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.fetchPage((long)this.getNodeId(), (String)this.getParentTitle());
    }

    public WikiPage fetchRedirectPage() {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.fetchPage((long)this.getNodeId(), (String)this.getRedirectTitle());
    }

    public List<FileEntry> getAttachmentsFileEntries() throws PortalException {
        return this.getAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getAttachmentsFileEntries(int start, int end) throws PortalException {
        List<Object> fileEntries = new ArrayList<FileEntry>();
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)0, (int)start, (int)end, null);
        }
        return fileEntries;
    }

    public List<FileEntry> getAttachmentsFileEntries(int start, int end, OrderByComparator obc) throws PortalException {
        List<Object> fileEntries = new ArrayList<FileEntry>();
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)0, (int)start, (int)end, (OrderByComparator)obc);
        }
        return fileEntries;
    }

    public int getAttachmentsFileEntriesCount() throws PortalException {
        int attachmentsFileEntriesCount = 0;
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            attachmentsFileEntriesCount = PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)0);
        }
        return attachmentsFileEntriesCount;
    }

    public long getAttachmentsFolderId() {
        if (this._attachmentsFolderId != 0L) {
            return this._attachmentsFolderId;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)this.getGroupId(), (String)"com.liferay.wiki");
        long nodeAttachmentsFolderId = this.getNodeAttachmentsFolderId();
        if (repository == null || nodeAttachmentsFolderId == 0L) {
            return 0L;
        }
        try {
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)nodeAttachmentsFolderId, (String)String.valueOf(this.getResourcePrimKey()));
            this._attachmentsFolderId = folder.getFolderId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._attachmentsFolderId;
    }

    public List<WikiPage> getChildPages() {
        try {
            return WikiPageLocalServiceUtil.getChildren((long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<FileEntry> getDeletedAttachmentsFileEntries() throws PortalException {
        return this.getDeletedAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getDeletedAttachmentsFileEntries(int start, int end) throws PortalException {
        List<Object> fileEntries = new ArrayList<FileEntry>();
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)8, (int)start, (int)end, null);
        }
        return fileEntries;
    }

    public int getDeletedAttachmentsFileEntriesCount() throws PortalException {
        int deletedAttachmentsFileEntriesCount = 0;
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)8);
        }
        return deletedAttachmentsFileEntriesCount;
    }

    public WikiNode getNode() {
        try {
            return WikiNodeLocalServiceUtil.getNode((long)this.getNodeId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return new WikiNodeImpl();
        }
    }

    public long getNodeAttachmentsFolderId() {
        WikiNode node = this.getNode();
        return node.getAttachmentsFolderId();
    }

    public WikiPage getParentPage() throws PortalException {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getParentTitle());
    }

    public List<WikiPage> getParentPages() {
        ArrayList<WikiPage> parentPages = new ArrayList<WikiPage>();
        WikiPage parentPage = this.fetchParentPage();
        if (parentPage != null) {
            parentPages.addAll(parentPage.getParentPages());
            parentPages.add(parentPage);
        }
        return parentPages;
    }

    public WikiPage getRedirectPage() throws PortalException {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getRedirectTitle());
    }

    @Override
    public long getTrashEntryClassPK() {
        return this.getResourcePrimKey();
    }

    public List<WikiPage> getViewableChildPages() {
        try {
            return WikiPageServiceUtil.getChildren((long)this.getGroupId(), (long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public WikiPage getViewableParentPage() {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        try {
            return WikiPageServiceUtil.getPage((long)this.getGroupId(), (long)this.getNodeId(), (String)this.getParentTitle());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public List<WikiPage> getViewableParentPages() {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        WikiPage page = this.getViewableParentPage();
        if (page != null) {
            pages.addAll(page.getViewableParentPages());
            pages.add(page);
        }
        return pages;
    }

    @Override
    public boolean isResourceMain() {
        return this.isHead();
    }

    public void setAttachmentsFolderId(long attachmentsFolderId) {
        this._attachmentsFolderId = attachmentsFolderId;
    }
}

